/*!
    \file command_node.h
    \brief Parses keyboard, mouse and remote input
    
    Contains methods to parse remote and local input and handles sending of input to remote CommandNodes
*/

#ifndef COMMAND_NODE_H
#define COMMAND_NODE_H

#include "stdincl.h"

#define N_STD_KEYS SDLK_LAST
#define N_BUTTONS 6
#define DEFAULT_KEYBIND_FILE "default.ini"

typedef struct
{
	char keys[N_STD_KEYS][CMD_LENGHT];
	char buttons[N_BUTTONS][CMD_LENGHT];
} KeyBindings;

class CommandNode {
 private:
 	bool bLocalInput;
 	int netID;
	KeyBindings* aliases;
	List<WorldEntity>* bound;
	int coord[2];
	
	void relay (Command* cmd);
	int* name_to_index (char* name);
	void process_local ();
	void process_network ();
	void send_over_networ();
	
 public:
  CommandNode (int ID);
  CommandNode (char* filename);
  ~CommandNode ();
  
  void load_bindings (char* filename);
  void bind (WorldEntity* entity);
  void unbind (WorldEntity* entity);
  void process ();
};

#endif
