/*!
    \file ini_parser.h
    \brief A small ini file parser
    
    Can be used to find a defined [Section] in an ini file and get the VarName=Value entries
*/

#ifndef INI_PARSER_H
#define INI_PARSER_H

#include "stdincl.h"

#define PARSELINELENGHT 512

class IniParser {
 private:
	FILE* stream;
	bool bInSection;
	
 public:
  IniParser (char* filename);
  ~IniParser ();
  
  int openFile( char* name);
  int getSection( char* section);
  int nextVar( char* name, char* value);
};

#endif
