/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      ...
 *
 */

#include "OrxonoxStableHeaders.h"
#include "BlinkingBillboard.h"

#include "core/CoreIncludes.h"
#include "core/XMLPort.h"

namespace orxonox
{
    CreateFactory(BlinkingBillboard);

    BlinkingBillboard::BlinkingBillboard(BaseObject* creator) : Billboard(creator)
    {
        RegisterObject(BlinkingBillboard);

        this->amplitude_ = 1.0f;
        this->frequency_ = 1.0f;
        this->phase_ = 0;
        this->time_ = 0;

        this->registerVariables();
    }

    BlinkingBillboard::~BlinkingBillboard()
    {
    }

    void BlinkingBillboard::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(BlinkingBillboard, XMLPort, xmlelement, mode);

        XMLPortParam(BlinkingBillboard, "amplitude", setAmplitude, getAmplitude, xmlelement, mode).defaultValues(1.0f);
        XMLPortParam(BlinkingBillboard, "frequency", setFrequency, getFrequency, xmlelement, mode).defaultValues(1.0f);
        XMLPortParam(BlinkingBillboard, "phase",     setPhase,     getPhase,     xmlelement, mode).defaultValues(Degree(0));
    }

    void BlinkingBillboard::registerVariables()
    {
        REGISTERDATA(this->amplitude_, network::direction::toclient);
        REGISTERDATA(this->frequency_, network::direction::toclient);
        REGISTERDATA(this->phase_,     network::direction::toclient);
    }

    void BlinkingBillboard::tick(float dt)
    {
        this->time_ += dt;
        this->setScale(this->amplitude_ * sin((6.2831853 * this->time_ + this->phase_.valueRadians()) * this->frequency_));
    }
}
