
#ifndef WORLD_H
#define WORLD_H

class Player;
class NPC;
class Environment;


class World {

 public:
  World ();
  ~World ();

  float primitiveMove;

  /* for easier use: map the first two player here */
  Player *localPlayer;
  Player *player1;
  Player *player2;

  /* a list of all players */
  struct playerList {
    playerList* next;
    Player* player;
    int number;
  };
  playerList* lastPlayer;

  /* a list of all non-player-characters */
  struct npcList {
    npcList* next;
    NPC* npc;
    int number;
  };
  npcList* lastNPC;

  /* a list of all environmental objects */
  struct envList {
    envList* next;
    Environment* env;
    int number;
  };
  envList* lastEnv;




  bool addPlayer(Player* player);
  bool removePlayer(Player* player);
  Player* getLocalPlayer();
  bool addNPC(NPC* npc);
  bool removeNPC(NPC* npc);
  bool addEnv(Environment* env);

  void drawWorld(void);
  void initEnvironement(void);
  void setWorldStep(float step);
  void updateWorld(void);
  void detectCollision(void);
  void testThaTest(void);

 private:
  float surface[120][120];
  float step;


};

#endif
