
#ifndef SHOOT_ROCKET_H
#define SHOOT_ROCKET_H



enum RocketType { HOMING, SIDEACC, BACKPARABLE, ROTATER};
enum RocketDirection {LEFT, RIGHT, UP, DOWN};


class ShootRocket {

 public:
  
  /* a list of all shoot-amental objects */
  struct shoot {
    enum RocketType type;
    shoot *next;
    float xCor;
    float yCor;
    float zCor;    
    float xVel;
    float yVel;
    float zVel;
    float xAcc;
    float yAcc;
    float zAcc;
    float age;
    float lifetime;
    float collisionRadius;
  };
  shoot* lastShoot;
  
  ShootRocket ();
  ~ShootRocket ();
  
  int inhibitor;
  float rotateAngle;

  void drawShoot(void);
  void addShoot(shoot* sh);
  void addBackParable(float x, float y, float z);
  void addSideAcc(float x, float y, float z, enum RocketDirection direction);
  void addRotater(float x, float y, float z);

  void setShootStep(float step);
  void removeShoot(shoot* sh);


 private:

  float step;

};

#endif
