

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer:
*/

#include <iostream>
#include <stdlib.h>
#include <GL/glut.h>

#include "shoot_laser.h"
#include "shoot_rocket.h"
#include "data_tank.h"

#include "player.h"

using namespace std;


Player::Player() 
   : WorldEntity() {
  //cout << "Player::Player" << endl;
  xCor = yCor = zCor = 0;
  shootLaser = new ShootLaser;
  shootRocket = new ShootRocket;
}

Player::~Player () 
{
  //delete shootLaser;
}


void Player::setPosition( float x, float y, float z)
{
  xCor = x; yCor = y; zCor = z;
}


void Player::getPosition(float* x, float* y, float* z)
{
  *x = xCor; *y = yCor; *z = zCor;
}


void Player::setCollisionRadius(float radius) 
{
  collisionRadius = radius;
}


void Player::goX(float x) 
{
  xCor += x;
}


void Player::goY(float y)
{
  yCor += y;
}

void Player::goZ(float z)
{
  zCor += z;
}



void Player::shoot(int n) 
{

  //  if (shootLaser->inhibitor++ <= 100)
  shootLaser->addShoot(xCor, yCor, zCor);
  // else if (shootLaser->inhibitor++ <= 200)
  shootLaser->addShootExt(xCor, yCor, zCor, .1, .4, .0);
  //  else if (shootLaser->inhibitor++ <= 300)
  shootLaser->addShootExt(xCor, yCor, zCor, -0.1, .4, .0);
  //  else
  shootLaser->inhibitor =0;
  
  //  if (shootRocket->inhibitor++ >=80)
  {
    shootRocket->addBackParable(xCor, yCor, zCor);
    shootRocket->addSideAcc(xCor, yCor, zCor, RIGHT);
    shootRocket->addSideAcc(xCor, yCor, zCor, LEFT);
    shootRocket->addRotater(xCor, yCor, zCor);
    //  if (shootRocket->inhibitor >=90)
    //        shootRocket->inhibitor =0;
  }
  //cout << "Player::shoot" << endl;
  
  /*
  shootLaser->addShoot(xCor, yCor, zCor);
  shootLaser->addShootExt(xCor, yCor, zCor, .1, .4, .0);
  shootLaser->addShootExt(xCor, yCor, zCor, -0.1, .4, .0);
  //shootRocket->addShoot(xCor, yCor, zCor);
  //cout << "Player::shoot" << endl;
  */
}


//void Player::addIO(InputOutput *io) {}


void Player::paint() 
{
  //cout << "Player::drawPlayer" << endl;
  glPushMatrix();
  glTranslatef(xCor, yCor, 3.0);
  glScalef(1.0, 3.0, 1.0);
  glutWireCube(1.0);
  glPopMatrix();
  /* draw all the shoots additionaly */
  shootLaser->drawShoot();
  shootRocket->drawShoot();
  //cout << "Player::drawPlayer, end" << endl;
}


























