

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: ...
   co-programmer: ...
*/

#include <iostream>

#include "world.h"
#include "input_output.h"
#include "player.h"

#include "input_output.h"

using namespace std;


/** 
   \brief InputOutput Module for each player
   \param wld A reference to the game-world
   
   This Class registers all moves, a player makes and passes it to the player object. ToDo: extend to support network players...
*/
InputOutput::InputOutput (World* world, Player* player) 
{
  this->world = world;
  this->player = player;
}



InputOutput::~InputOutput () {}


void InputOutput::setPlayerStep(float step)
{
  cout << "setting player step to: " << step << endl;
  this->step = step;
}


void InputOutput::goUp() 
{
  //cout << "InoutOutput::goUp" << endl;
  (*player).goY(step);
}

void InputOutput::goDown() 
{
  (*player).goY(-step);
}

void InputOutput::goLeft()
{
  (*player).goX(-step);

}

void InputOutput::goRight()
{

  (*player).goX(step);
}

void InputOutput::shoot()
{
  (*player).shoot(1);
}
