

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer:
*/


#include "player.h"
#include <iostream>
#include <stdlib.h>


using namespace std;


Player::Player () {
  // cout << "Player::Player" << endl;
  xCor = yCor = zCor = 0;
  shootLaser = new ShootLaser;
  shootRocket = new ShootRocket; 
  // Loads the 3ds Model, John
  TestModel.Import3ds();
}

Player::~Player () 
{
  //delete shootLaser;
}


void Player::setPosition( float x, float y, float z)
{
  xCor = x; yCor = y; zCor = z;
}


void Player::getPosition(float* x, float* y, float* z)
{
  *x = xCor; *y = yCor; *z = zCor;
}


void Player::setCollisionRadius(float radius) 
{
  collisionRadius = radius;
}


void Player::goX(float x) 
{
  //cout << "Player::goX" << endl;
  xCor += x;
}


void Player::goY(float y)
{
  yCor += y;
}

void Player::goZ(float z)
{
  zCor += z;
}

void Player::shoot(int n) 
{
  //  if (shootLaser->inhibitor++ <= 100)
    shootLaser->addShoot(xCor, yCor, zCor);
    // else if (shootLaser->inhibitor++ <= 200)
    shootLaser->addShootExt(xCor, yCor, zCor, .1, .4, .0);
    //  else if (shootLaser->inhibitor++ <= 300)
    shootLaser->addShootExt(xCor, yCor, zCor, -0.1, .4, .0);
    //  else
    shootLaser->inhibitor =0;
  
    //  if (shootRocket->inhibitor++ >=80)
    {
      shootRocket->addBackParable(xCor, yCor, zCor);
      shootRocket->addSideAcc(xCor, yCor, zCor, RIGHT);
      shootRocket->addSideAcc(xCor, yCor, zCor, LEFT);
      shootRocket->addRotater(xCor, yCor, zCor);
      //  if (shootRocket->inhibitor >=90)
      //	shootRocket->inhibitor =0;
    }
  //cout << "Player::shoot" << endl;
}


//void Player::addIO(InputOutput *io) {}


void Player::drawPlayer(void) 
{
  glPushMatrix();
  glTranslatef(xCor, yCor, 3.0);
  glScalef(1.0, 3.0, 1.0);
  // Draws the TestModel as a Wireframe, John
  TestModel.Draw( GL_LINE_STRIP );
  glPopMatrix();
  /* draw all the shoots additionaly */
  shootLaser->drawShoot();
  shootRocket->drawShoot();
  //cout << "Player::drawPlayer" << endl;
}


























