#ifndef _ORXONOX_GUI_H
#define _ORXONOX_GUI_H

#include <stdlib.h>
#include <string.h>
#include <gtk/gtkmain.h>
#include <gtk/gtkwindow.h>
#include <gtk/gtkframe.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkbutton.h>
#include <gtk/gtkcheckbutton.h>
#include <gtk/gtkhscale.h>
#include <gtk/gtkoptionmenu.h>
#include <gtk/gtkmenu.h>
#include <gtk/gtkmenuitem.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkimage.h>

class OrxonoxGui
{
 public:
  OrxonoxGui (int argc, char *argv[]);
  ~OrxonoxGui ();

};

class Widget
{
 public:
  Widget* next;
  GtkWidget* widget;
  int is_option;

  //virtual void create ();
  //  void addWidget ();
  void connectSignal (char* event, gint (*signal)(GtkWidget*, GdkEvent*, void *));
  void connectSignal (char* event, gint (*signal)(GtkWidget*, Widget *));
  void show ();
  void listOptions ();
  void setOptions ();

};



class Container : public Widget
{
 private:
  int borderwidth;
  int policy;
  char* label;
  
 public:
  Widget* down;
  void setBorderWidth (int borderwidth);
  virtual void setTitle (char* title) = 0;
  void fill (Widget *lowerWidget);
};

class Window : public Container
{
 public:
  Window (char* windowName);
  Window (void);
  ~Window ();
  
  void setTitle (char* title);
  void showall ();
  static gint orxonox_gui_quit (GtkWidget *widget, GdkEvent *event, gpointer data);
};

class Frame :public Container
{
 public:
  Frame (char* frameName);
  Frame (void);
  ~Frame ();
  
  void setTitle (char* title);
};

class Box : public Widget
{
 public:
  Box (void);
  Box (char boxtype);
  ~Box (void);

  Widget* down;
  void fill (Widget* lowerWidget);

};

class Image : public Widget
{
 public:
  Image (char* imgaename);
  ~Image ();
};

class Option : public Widget
{
 public:
  //virtual gint OptionChange (GtkWidget *widget, GdkEvent *event, gpointer data);
  
  int value;
  char* option_name;
  char* flag_name;
  char* flag_name_short;
  int default_value;

  void setFlagName (char* flagname, int defaultvalue);
  void setFlagName (char* flagname, char* flagnameshort, int defaultvalue);
  virtual void redraw () = 0;
};

class Button : public Option 
{
 public:
  Button (char* buttonname);
  ~Button (void);
  
  void redraw();
};

class CheckButton : public Option
{
 public:
  CheckButton (char* buttonname);
  ~CheckButton (void);
  static gint OptionChange (GtkWidget* widget, Widget* checkbutton);
  void redraw ();
};

class Slider : public Option
{
 public:
  Slider (char* slidername,int start, int end);
  ~Slider ();
  static gint OptionChange (GtkWidget* widget, Widget* slider);
  void redraw();
};

class Menu : public Option
{
 public:
  Menu (char* menuname, ...);
  ~Menu ();

  static gint OptionChange (GtkWidget* widget, Widget* menu);
  void redraw();
};

class Label : public Widget
{
 public:
  Label ();
  Label (char* text);
  ~Label ();
  
  void setText (char * text);
  char* getText ();
};

//gint orxonox_gui_quit (GtkWidget *widget, GdkEvent *event, gpointer data);

#endif /* _ORXONOX_GUI_H */
