/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  


   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer:
*/


#include "orxonox_console_entry.h"



OrxonoxConsoleEntry::OrxonoxConsoleEntry(void)
{}

OrxonoxConsoleEntry::OrxonoxConsoleEntry(OrxonoxConsoleLog* log)
{
  consoleLog = log; 
}


GtkWidget* OrxonoxConsoleEntry::createEntry()
{
  frame = gtk_frame_new ("Console Entry:");


  gtk_container_set_border_width (GTK_CONTAINER(frame), 5);
  {
    entrybox = gtk_hbox_new (FALSE, 5);
    {
      entry = gtk_entry_new();
      g_signal_connect(GTK_ENTRY(entry), "activate", G_CALLBACK(submit), this);
      gtk_box_pack_start(GTK_BOX(entrybox), entry, TRUE, TRUE, 5);
      
      
      button = gtk_button_new_with_label("Submit");
      g_signal_connect(GTK_BUTTON(button), "clicked", G_CALLBACK(submit), this);
      gtk_box_pack_start(GTK_BOX(entrybox), button, FALSE, FALSE, 5);
    }
    gtk_container_add(GTK_CONTAINER(frame), entrybox);
  }
  return (frame);
}

void OrxonoxConsoleEntry::setLog(OrxonoxConsoleLog* log)
{
  consoleLog = log;
}


void OrxonoxConsoleEntry::submit(GtkWidget *widget,  OrxonoxConsoleEntry* entry)
{
  char* entryText = (char*)gtk_entry_get_text(GTK_ENTRY(entry->entry));
  entry->sendtoLog(entryText);
  gtk_entry_set_text(GTK_ENTRY(entry->entry),"");
  return;
}


void OrxonoxConsoleEntry::sendtoLog(char* submitText)
{
  consoleLog->appendText(submitText);
  return;
}
