#include "orxonox_gui_audio.h"

OrxonoxGuiAudio::OrxonoxGuiAudio ()
{
  audioFrame = new Frame ("Audio-Options:");
  audioBox = new Box ('v');
  
  enableSound = new CheckButton ("Disable Sound");
  enableSound->setFlagName ("no-sound", 0);
  audioBox->fill (enableSound);
  Label* musicVolumeLabel = new Label ("Music Volume");
  audioBox->fill (musicVolumeLabel);
  musicVolume = new Slider ("Music Volume", 0, 100);
  musicVolume->setFlagName ("music-volume", "m", 80);
  audioBox->fill (musicVolume);
  Label* effectsVolumeLabel = new Label ("Effects Volume");
  audioBox->fill (effectsVolumeLabel);
  effectsVolume = new Slider ("Effects Volume", 0, 100);
  effectsVolume->setFlagName ("effects-volume", "e", 80);
  audioBox->fill (effectsVolume);

  audioFrame->fill (audioBox);
}

Frame* OrxonoxGuiAudio::getFrame ()
{
  return audioFrame;
}
