#include "orxonox_gui_flags.h"
#include <iostream.h>


OrxonoxGuiFlags::OrxonoxGuiFlags (Widget* widget)
{
  flagText = (char*) malloc (1024);

  flagsFrame = new Frame ("Orxonox-Startup-Flags:");
  flagsBox = new Box ('v');

  flagsLabel = new Label ();
  flagsBox->fill (flagsLabel);
  shortFlags = new CheckButton ("shortFlags");
  flagsBox->fill (shortFlags);

  flagsFrame->fill (flagsBox);
}

Frame* OrxonoxGuiFlags::getFrame ()
{
  return flagsFrame;
}

void OrxonoxGuiFlags::setTextFromFlags (Widget* widget)
{
  sprintf (flagText, "");
  strcat (flagText, "orxonox");
  FlagsText (widget);
  flagsLabel->setText (flagText);
}

void OrxonoxGuiFlags::FlagsText(Widget* widget)
{
  if (widget->is_option >= 1)
    if  (static_cast<Option*>(widget)->value != static_cast<Option*>(widget)->default_value && (strcmp (static_cast<Option*>(widget)->flag_name, "") || strcmp (static_cast<Option*>(widget)->flag_name_short, "")))
      {
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(shortFlags->widget)))
	  {
	    strcat (flagText, " -");
	    strcat (flagText, static_cast<Option*>(widget)->flag_name_short);
	  }
	else
	  {
	    strcat (flagText, " --");
	    strcat (flagText, static_cast<Option*>(widget)->flag_name);
	  }
	if (static_cast<Option*>(widget)->is_option == 2)
	  {
	    sprintf (flagText, "%s=%i", flagText, static_cast<Option*>(widget)->value);
	  }
      }
  switch (widget->is_option)
    {
    case -1:
      FlagsText (static_cast<Container*>(widget)->down);
      break;
    case -2:
      FlagsText (static_cast<Box*>(widget)->down);
      break;
    } 
  
  if (widget->next != NULL)
    FlagsText (widget->next);
}


