#include "orxonox_gui_exec.h"
#include <iostream>
#include <string>

OrxonoxGuiExec::OrxonoxGuiExec (Window* orxonoxGUI)
{
  configFile = (char*)malloc (512*sizeof (char));

  execFrame = new Frame ("Execute-Tags:");
  execBox = new Box ('v');
  
  start = new Button ("Start");
  execBox->fill (start);
  saveSettings = new CheckButton ("Save Settings");
  saveSettings->value = 1;
  execBox->fill (saveSettings);
  verboseMode = new Menu ("verbose mode", "no output", "verbose", "debug", "lastItem");
  verboseMode->setFlagName ("verbose", "v", 0);
  execBox->fill (verboseMode);
  alwaysShow = new CheckButton ("Always Show this Menu");
  alwaysShow->setFlagName ("gui", "g", 0);
  execBox->fill (alwaysShow);
  quit = new Button ("Quit");
  quit->connectSignal ("clicked", orxonoxGUI->orxonox_gui_quit);
  execBox->fill (quit);

  execFrame->fill (execBox);
}

Frame* OrxonoxGuiExec::getFrame ()
{
  return execFrame;
}

/* FILE HANDLING */

void OrxonoxGuiExec::setFilename (char* filename)
{
  char* buffer = (char*) malloc (512*sizeof(buffer));
  sprintf (buffer, "%s", filename);
  if (!strncmp (buffer, "~/", 2))
  {
#ifdef __WIN32__
    sprintf (configFile, "%s/%s", getenv ("USERPROFILE"), buffer+2);
#else
    sprintf (configFile, "%s/%s", getenv ("HOME"), buffer+2);
#endif
  }
  else if (buffer)
    sprintf(configFile, "%s", buffer);
  delete buffer;
}

int OrxonoxGuiExec::shouldsave ()
{
  return ( static_cast<Option*>(saveSettings)->value);
}

void OrxonoxGuiExec::writeToFile (Widget* widget)
{
  CONFIG_FILE = fopen (configFile, "w");
  if (CONFIG_FILE)
    writeFileText (widget);
  fclose (CONFIG_FILE);
}

void OrxonoxGuiExec::writeFileText (Widget* widget)
{
  if (widget->is_option >= 1)
    if  (strcmp (static_cast<Option*>(widget)->flag_name, "") || strcmp (static_cast<Option*>(widget)->flag_name_short, ""))
      {
	char Buffer[256];
	char* space2under;
	sprintf (Buffer, "%s", static_cast<Option*>(widget)->option_name);
	if (strchr (Buffer, '_'))
	  cout << "Warning Optionname" << Buffer << " is not Valid for Saving, because it includes an underscore" << endl; 
	while (space2under = strchr(Buffer, ' '))
	  {
	    sprintf (space2under, "_%s", space2under+1);
	  }
	fprintf (CONFIG_FILE, "%s = %i\n", Buffer, static_cast<Option*>(widget)->value);
      }
  switch (widget->is_option)
    {
    case -1:
      writeFileText (static_cast<Container*>(widget)->down);
      break;
    case -2:
      writeFileText (static_cast<Box*>(widget)->down);
      break;
    } 
  
  if (widget->next != NULL)
    writeFileText (widget->next);
}

void OrxonoxGuiExec::readFromFile (Widget* widget)
{
  CONFIG_FILE = fopen (configFile, "r");
  if (CONFIG_FILE)
    {
      char Buffer[256] = "";
      char Variable[256]= "";
      int Value;
      while (fscanf (CONFIG_FILE, "%s", Buffer) != EOF)
	{
	  if (!strcmp (Buffer, "="))
	    {
	      char* under2space;
	      while (under2space = strchr(Variable, '_'))
		{
		  sprintf (under2space, " %s", under2space+1);
		}
	      
	      fscanf (CONFIG_FILE, "%s", Buffer);
	      Value = atoi(Buffer);
	      readFileText (widget, Variable, Value);
	      sprintf (Variable, "");
	    }
	  sprintf (Variable, "%s", Buffer);
	}
      widget->setOptions();
    }
}

void OrxonoxGuiExec::readFileText (Widget* widget, char* variableName, int variableValue)
{
  if (widget->is_option >= 1)
    if (!strcmp (static_cast<Option*>(widget)->option_name, variableName))
	static_cast<Option*>(widget)->value = variableValue;

  switch (widget->is_option)
    {
    case -1:
      readFileText (static_cast<Container*>(widget)->down, variableName, variableValue);
      break;
    case -2:
      readFileText (static_cast<Box*>(widget)->down, variableName, variableValue);
      break;
    } 

  if (widget->next != NULL)
    readFileText (widget->next, variableName, variableValue);


}
