#include <iostream.h>

#include "orxonox_gui.h"
#include "orxonox_gui_video.h"
#include "orxonox_gui_audio.h"
#include "orxonox_gui_exec.h"
#include "orxonox_gui_flags.h"

  Window* orxonoxGUI;
  OrxonoxGuiVideo* video;
  OrxonoxGuiAudio* audio;
  OrxonoxGuiExec* exec;
  OrxonoxGuiFlags* flags;  

int main( int argc, char *argv[] )
{
  OrxonoxGui* orxonoxgui = new OrxonoxGui(argc, argv);
  return 0;
}

/* ORXONOXGUI */

OrxonoxGui::OrxonoxGui (int argc, char *argv[])
{
  /**
   * Initializes the Gui
   */
  gtk_init (&argc, &argv);
  gtk_rc_parse( "rc" );
  
  orxonoxGUI = new Window("Graphical Orxonox Launcher");
  orxonoxGUI->connectSignal ("destroy", orxonoxGUI->orxonox_gui_quit);
  orxonoxGUI->connectSignal ("delete_event", orxonoxGUI->orxonox_gui_quit);
  
  Box* windowBox = new Box ('v');
  
  Box* avBox = new Box ('h');

  video = new OrxonoxGuiVideo ();
  avBox->fill (video->getFrame ());
  audio = new OrxonoxGuiAudio ();
  avBox->fill (audio->getFrame ());
      
  windowBox->fill (avBox);
    
  exec = new OrxonoxGuiExec (orxonoxGUI);
  windowBox->fill (exec->getFrame ());

  flags = new OrxonoxGuiFlags (orxonoxGUI);
  windowBox->fill (flags->getFrame ());
  
  orxonoxGUI->fill (windowBox);
  flags->setTextFromFlags (orxonoxGUI);

  exec->setFilename ("~/.orxonox.conf");
  exec->readFromFile (orxonoxGUI);
  orxonoxGUI->listOptions();

  orxonoxGUI->showall ();

  
  gtk_main();
}

/* WIDGET */

void Widget::connectSignal (char* event, gint (*signal)(GtkWidget*, GdkEvent*, void *))
{
  /** 
   * Connect any signal to any given Sub-widget
   */
  g_signal_connect (G_OBJECT (this->widget), event, G_CALLBACK (signal), NULL);
}

void Widget::connectSignal (char* event, gint (*signal)( GtkWidget*, Widget *))
{
  /**
   * Connect a signal with additionally passing the whole Object
   */
  g_signal_connect (G_OBJECT (this->widget), event, G_CALLBACK (signal), this);
}

void Widget::show()
{
  /**
   * Function to Show any Widget
   */
  gtk_widget_show (widget);
}

void Widget::listOptions ()
{
  /** 
   * This is For listing all the Options witch are located beneath this Widget.
   */
  if (this->is_option >= 1)
    cout << static_cast<Option*>(this)->option_name <<" is : " << static_cast<Option*>(this)->value <<endl;

  switch (this->is_option)
    {
    case -1:
      static_cast<Container*>(this)->down->listOptions ();
      break;
    case -2:
      static_cast<Box*>(this)->down->listOptions ();
      break;
    } 

  if (this->next != NULL)
    this->next->listOptions ();
}

void Widget::setOptions ()
{
  /** 
   * This is For listing all the Options witch are located beneath this Widget.
   */
  if (this->is_option >= 1)
    static_cast<Option*>(this)->redraw();// <<" is : " << static_cast<Option*>(this)->value <<endl;

  switch (this->is_option)
    {
    case -1:
      static_cast<Container*>(this)->down->setOptions ();
      break;
    case -2:
      static_cast<Box*>(this)->down->setOptions ();
      break;
    } 

  if (this->next != NULL)
    this->next->setOptions ();
}

/* CONTAINERS*/

void Container::fill (Widget *lowerWidget)
{
  /**
   * fill any given Container with a lowerwidet
   */
  if (this->down == NULL)
    {
      gtk_container_add (GTK_CONTAINER (this->widget), lowerWidget->widget);
      this->down = lowerWidget;
    }
  else
    cout << "!!error!! You try to put more than one Widget into a container.\nnot including this item."<<endl;
}

// gtk_container_set_border_width (GTK_CONTAINER (widget), 5);

/* WINDOW */

Window::Window (void)
{
  /**
   * Creating a Window
   */
  is_option = -1;
  next = NULL;
  down = NULL;
  widget = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy (GTK_WINDOW(widget), TRUE, TRUE, TRUE);
  gtk_container_set_border_width (GTK_CONTAINER (widget), 3);
}

Window::Window (char* windowName)
{
  /**
   * Creating a Window with passing a name
   */
  is_option = -1;
  next = NULL;
  down = NULL;
  widget = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy (GTK_WINDOW (widget), TRUE, TRUE, TRUE);
  gtk_container_set_border_width (GTK_CONTAINER (widget), 3);
  this->setTitle (windowName);
}

Window::~Window ()
{
  /**
   * Destoying a Window (not implemented)
   */
}

void Window::showall ()
{
  /**
   * Shows all Widgets that are included within this Widget
   */
  gtk_widget_show_all  (widget);
}

void Window::setTitle (char* title)
{
  /**
   * Set The Window title to title
   */
  gtk_window_set_title (GTK_WINDOW (widget), title);
}


gint Window::orxonox_gui_quit (GtkWidget *widget, GdkEvent *event, gpointer data)
{
  /**
   * Quits the orxonox_GUI
   */
  exec->writeToFile (orxonoxGUI);

  gtk_main_quit();
  return FALSE;
}


/* FRAME */

Frame::Frame (void)
{
  /** 
   * Creates a new Frame without a name
   */
  is_option = -1;
  next = NULL;
  down = NULL;
  widget = gtk_frame_new ("");
  gtk_container_set_border_width (GTK_CONTAINER (widget), 3);
}
Frame::Frame (char* title)
{
  /**
   * Creates a new Frame with name title
   */
  is_option = -1;
  next = NULL;
  down = NULL;
  widget = gtk_frame_new (title);
  gtk_container_set_border_width (GTK_CONTAINER (widget), 3);
}
Frame::~Frame ()
{
  /**
   * Destroys given Frame (not implemented yet)
   */
}

void Frame::setTitle (char* title)
{
  /**
   * Sets the Frames name to title
   */
  gtk_frame_set_label (GTK_FRAME (widget), title);
}



/* BOX */

Box::Box (void)
{
  /**
   * Creates a new horizontal Box
   */
  is_option = -2;
  next = NULL;
  down = NULL;
  widget = gtk_hbox_new(FALSE, 0);
}
Box::Box (char boxtype)
{
  /**
   * Creates a new Box if boxtype is 'v' it will be vertically, if 'h' it will be horizontally
   */
  is_option = -2;
  next = NULL;
  down = NULL;
  if (boxtype == 'v')
    {
      widget = gtk_vbox_new (FALSE, 0);
    }
  else
    {
      widget = gtk_hbox_new (FALSE, 0);
    }
}

Box::~Box ()
{
  /**
   * Destroys given Frame (not implemented yet)
   */
}

void Box::fill (Widget *lowerWidget)
{
  /**
   * Fill a Box with its lowerwidgets
   */
  gtk_box_pack_start (GTK_BOX (this->widget), lowerWidget->widget, TRUE, TRUE, 0);
  if (this->down == NULL)
    this->down = lowerWidget;
  else
    {
      Widget* tmp;
      tmp = this->down;
      while (tmp->next != NULL)
	{
	  tmp = tmp->next;
	}
      tmp->next = lowerWidget;
    }
}


/* OPTION */

void Option::setFlagName (char* flagname, int defaultvalue)
{
  flag_name = flagname;
  default_value = defaultvalue;
  cout << "Set Flagname of " << option_name << " to " << flagname << endl;
}

void Option::setFlagName (char* flagname, char* flagnameshort,  int defaultvalue)
{
  /**
   * \brief Sets the Flagname of an Option. If it is set different then "" this Option will be saved to the Configurationfile
   */
  flag_name = flagname;
  flag_name_short = flagnameshort;
  default_value = defaultvalue;
  cout << "Set Flagname of " << option_name << " to " << flagname << endl;
}


/* BUTTON */
Button::Button(char* buttonname)
{
  /**
   * Creates a new Button with name buttonname
   */
  is_option = 0;
  value = 0;
  next = NULL;
  option_name = buttonname;
  flag_name = "";
  flag_name_short = "";
  default_value = 0;
  widget = gtk_button_new_with_label (buttonname);
}

void Button::redraw ()
{
}

/* CHECKBUTTON */
CheckButton::CheckButton (char* buttonname)
{
  /**
   * Creates a new CheckButton with name buttonname
   */
  is_option = 1;
  value = 0;
  next = NULL;
  option_name = buttonname;
  flag_name = "";
  flag_name_short = "";
  default_value = 0;
  widget = gtk_check_button_new_with_label (buttonname);

  this->connectSignal ("clicked", this->OptionChange);
}

gint CheckButton::OptionChange (GtkWidget *widget, Widget* checkbutton)
{
  /** 
   * Writes value, if changed on the checkbutton, to the object.
   */
  static_cast<CheckButton*>(checkbutton)->value = (int)gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON ((CheckButton*)checkbutton->widget));
  flags->setTextFromFlags(orxonoxGUI);
  cout << static_cast<CheckButton*>(checkbutton)->option_name << " set to: " << static_cast<CheckButton*>(checkbutton)->value << endl;
}

void CheckButton::redraw ()
{
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), value);
}

/* SLIDER */
Slider::Slider (char* slidername, int start, int end)
{
  /**
   * Creates a new Slider with name slidername a beginning value of start and an end value of end.
   */
  is_option = 2;
  value = 0;
  next = NULL;
  option_name = slidername;
  flag_name = "";
  flag_name_short = "";
  default_value = 0;
  widget = gtk_hscale_new_with_range (start, end, 5);
  value = start;

  this->connectSignal ("value_changed", this->OptionChange);
}

gint Slider::OptionChange (GtkWidget *widget, Widget* slider)
{
  /** 
   * Writes value, if changed on the slider, to the object.
   */
  static_cast<Slider*>(slider)->value = (int)gtk_range_get_value (GTK_RANGE ((Slider*)slider->widget));
  flags->setTextFromFlags(orxonoxGUI);
  cout << static_cast<Slider*>(slider)->option_name << " set to: "<< static_cast<Slider*>(slider)->value << endl;
}

void Slider::redraw ()
{
  gtk_range_set_value (GTK_RANGE (widget), value);
}

Menu::Menu (char* menuname, ...)
{
  /** 
   * Creates an Menu-Item-list out of multiple input. Consider, that the last input argument has to be "lastItem" for this to work.
   */
  is_option = 2;
  value = 0;
  next = NULL;
  option_name = menuname;
  flag_name = "";
  flag_name_short = "";
  default_value = 0;
  char *tmp;
  va_list itemlist;
  widget = gtk_option_menu_new ();
  GtkWidget* menu = gtk_menu_new ();
  GtkWidget* item;

  va_start (itemlist, menuname);
  while (strcmp (tmp = va_arg (itemlist, char*), "lastItem"))
    {
      item = gtk_menu_item_new_with_label (tmp);
      gtk_menu_shell_append(GTK_MENU_SHELL (menu), item);
    }
  va_end(itemlist);

  gtk_option_menu_set_menu (GTK_OPTION_MENU (widget), menu);
  this->connectSignal ("changed", this->OptionChange);
}

gint Menu::OptionChange (GtkWidget *widget, Widget* menu)
{
  /** 
   * Writes value, if changed on the Menu, to the object.
   */
  static_cast<Menu*>(menu)->value = (int)gtk_option_menu_get_history (GTK_OPTION_MENU (menu->widget));
  flags->setTextFromFlags(orxonoxGUI);
  cout << static_cast<Menu*>(menu)->option_name << " changed to : " << static_cast<Menu*>(menu)->value << endl;
}

void Menu::redraw ()
{
  gtk_option_menu_set_history (GTK_OPTION_MENU (widget), value);
}

Label:: Label ()
{
  is_option = 0;
  next = NULL;
  widget = gtk_label_new ("");
  gtk_widget_set_usize (widget, 260, 60);
  gtk_label_set_line_wrap (GTK_LABEL(widget), TRUE);
}

Label:: Label (char* text)
{
  is_option = 0;
  next = NULL;
  widget = gtk_label_new (text);
  gtk_label_set_line_wrap (GTK_LABEL(widget), TRUE);
}

Label::~Label ()
{}
  
void Label::setText (char * text)
{
  gtk_label_set_text (GTK_LABEL (this->widget), text);
}

char* Label::getText ()
{
  return ((char*)gtk_label_get_text (GTK_LABEL (this->widget)));
}
