/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      ...
 *   Co-authors:
 *      ...
 *
 */

#ifndef _Mesh_H__
#define _Mesh_H__

#include "OrxonoxPrereqs.h"

#include <string>
#include <OgreEntity.h>

namespace orxonox
{
    class _OrxonoxExport Mesh
    {
        public:
            Mesh();
            ~Mesh();

            void setMeshSource(const std::string& file);

            inline Ogre::Entity* getEntity()
                { return this->entity_; }

            const std::string& getName() const;

            void setVisible(bool bVisible);
            bool isVisible() const;

        private:
            static unsigned int meshCounter_s;
            Ogre::Entity* entity_;
    };
}

#endif /* _Mesh_H__ */
