/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      ...
 *
 */

#ifndef _Template_H__
#define _Template_H__

#include <map>

#include "OrxonoxPrereqs.h"
#include "core/BaseObject.h"
#include "tinyxml/ticpp.h"

namespace orxonox
{
    class _OrxonoxExport Template : public BaseObject
    {
        public:
            Template();
            virtual ~Template();

            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode);

            inline void setLink(const std::string& link)
                { this->link_ = link; this->bIsLink_ = (link != ""); }
            inline const std::string& getLink() const
                { return this->link_; }

            inline void setXMLElement(const Element& xmlelement)
                { this->xmlelement_ = xmlelement; }
            const Element& getXMLElement() const;

            void setBaseclass(const std::string& baseclass);
            inline const std::string& getBaseclass() const
                { return this->baseclass_; }
            inline Identifier* getBaseclassIdentifier() const
                { return this->baseclassIdentifier_; }

            void applyOn(BaseObject* object);

            static std::map<std::string, Template*>& getTemplateMap();
            static Template* getTemplate(const std::string& name);
            static void apply(const std::string& name, BaseObject* object);

        private:
            Element xmlelement_;
            std::string link_;
            std::string baseclass_;
            Identifier* baseclassIdentifier_;
            bool bIsLink_;
            mutable bool bIsReturningXMLElement_;
    };
}

#endif /* _Template_H__ */
