/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Reto Grieder
 *   Co-authors:
 *      ...
 *
 */

#include "OrxonoxStableHeaders.h"
#include "GSRoot.h"

#include "core/Factory.h"
#include "core/ConfigFileManager.h"
#include "core/ConfigValueIncludes.h"
#include "core/ConsoleCommand.h"
#include "core/Debug.h"
#include "core/Exception.h"
#include "core/TclBind.h"
#include "core/Core.h"
#include "core/CommandLine.h"
#include "GraphicsEngine.h"
#include "Settings.h"

namespace orxonox
{
    SetCommandLineArgument(dataPath, std::string("./"));

    GSRoot::GSRoot()
        : GameState("root")
        , settings_(0)
        , graphicsEngine_(0)
    {
    }

    GSRoot::~GSRoot()
    {
    }

    void GSRoot::enter()
    {
#if ORXONOX_DEBUG_MODE == 1
        ConfigFileManager::getSingleton()->setFile(CFT_Settings, "orxonox_d.ini");
#else
        ConfigFileManager::getSingleton()->setFile(CFT_Settings, "orxonox.ini");
#endif

        // creates the class hierarchy for all classes with factories
        Factory::createClassHierarchy();

        // instantiate Settings class
        this->settings_ = new Settings();

        const CommandLineArgument<std::string>* dataPath = CommandLine::getCommandLineArgument<std::string>("dataPath");
        if (!dataPath->hasDefaultValue())
        {
            if (*dataPath->getValue().end() != '/' && *dataPath->getValue().end() != '\\')
                Settings::tsetDataPath(dataPath->getValue() + "/");
            else
                Settings::tsetDataPath(dataPath->getValue());
        }

        // initialise TCL
        TclBind::getInstance().setDataPath(Settings::getDataPath());

        // initialise graphics engine. Doesn't load the render window yet!
        graphicsEngine_ = new GraphicsEngine();
        graphicsEngine_->setup();       // creates ogre root and other essentials

        // console commands
        FunctorMember<GSRoot>* functor = createFunctor(&GSRoot::loadGame);
        functor->setObject(this);
        CommandExecutor::addConsoleCommandShortcut(createConsoleCommand(functor, "loadGame"));
    }

    void GSRoot::leave()
    {
        delete graphicsEngine_;

        delete settings_;
    }

    bool GSRoot::tick(float dt)
    {
        if (this->getActiveChild())
            this->getActiveChild()->tick(dt);
        return true;
    }

    /**
    @brief
        Requests a state.
    */
    void GSRoot::loadGame(const std::string& name)
    {
        this->requestState(name);
    }
}
