/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Reto Grieder
 *   Co-authors:
 *      ...
 *
 */

/**
  @file
  @brief Contains all the necessary forward declarations for all classes and structs.
*/

#ifndef _NetworkPrereqs_H__
#define _NetworkPrereqs_H__

#include "OrxonoxPlatform.h"

//-----------------------------------------------------------------------
// Shared library settings
//-----------------------------------------------------------------------
#if (ORXONOX_PLATFORM == ORXONOX_PLATFORM_WIN32) && !defined( NETWORK_STATIC_BUILD )
#  ifdef NETWORK_SHARED_BUILD
#    define _NetworkExport __declspec(dllexport)
#  else
#    if defined( __MINGW32__ )
#      define _NetworkExport
#    else
#      define _NetworkExport __declspec(dllimport)
#    endif
#  endif
#elif defined ( ORXONOX_GCC_VISIBILITY )
#  define _NetworkExport  __attribute__ ((visibility("default")))
#else
#  define _NetworkExport
#endif

//-----------------------------------------------------------------------
// fixed width integers
//-----------------------------------------------------------------------
#if ORXONOX_COMPILER == ORXONOX_COMPILER_MSVC
typedef __int8            int8_t;
typedef __int16           int16_t;
typedef __int32           int32_t;
typedef __int64           int64_t;
typedef unsigned __int8   uint8_t;
typedef unsigned __int16  uint16_t;
typedef unsigned __int32  uint32_t;
typedef unsigned __int64  uint64_t;
#else
# include "inttypes.h"
#endif

//-----------------------------------------------------------------------
// Forward declarations
//-----------------------------------------------------------------------
namespace network
{
  class Client;
  class ClientConnection;
  class ClientFrameListener;
  class ClientInformation;
  class ConnectionManager;
  class GameStateClient;
  class GameStateManager;
  class PacketBuffer;
  class PacketDecoder;
  class PacketGenerator;
  class Server;
  class ServerFrameListener;
  class Synchronisable;
  struct ack;
  struct chat;
  struct classid;
  struct welcome;
  struct connectRequest;
  struct ClientList;
  struct GameState;
  struct GameStateCompressed;
  struct keyboard;
  struct mouse;
  struct PacketEnvelope;
  struct QueueItem;
  struct syncData;
  struct synchronisableVariable;
}

#endif /* _NetworkPrereqs_H__ */
