/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Viviane Yang
 *   Co-authors:
 *      ...
 *
 */

/*  TODO: 

    @file Asteroids2DShip.cc
    @brief Implementation of the Asteroids2DShip class.
*/

#include "Asteroids2DShip.h"
#include "Asteroids2DStone.h"
#include "Asteroids2D.h"
#include "core/CoreIncludes.h"

namespace orxonox
{
    RegisterClass(Asteroids2DShip);

    Asteroids2DShip::Asteroids2DShip(Context* context) : SpaceShip(context)
    {
        RegisterObject(Asteroids2DShip);

        this->bImmune = false;
        this->width = 1043;
        this->height = 646;

        //timer.setTimer(3.5f, true, createExecutor(createFunctor(&Asteroids2DShip::showorientation, this)));
    }

    //Use this function to display your position on the field -> to determine field width and height
    void Asteroids2DShip::showposition()
    {
        Vector3 pos = this->getPosition();
        orxout() << "x = "<< pos.x << " y = " << pos.y << " z = "<< pos.z << endl; 
    }

    //Same thing for orientation
    void Asteroids2DShip::showorientation()
    {
        Quaternion ort = this->getOrientation();
        orxout() << "w = " << ort.w << " x = " << ort.x << " y = " << ort.y << "z = " << ort.z << endl;
    }

    void Asteroids2DShip::tick(float dt)
    {
        SUPER(Asteroids2DShip, tick, dt);
        Vector3 pos = this->getPosition();

        //ensure that the ship stays in playing field
        if(pos.x > width/2)   pos.x = -width/2;
        if(pos.x < -width/2)  pos.x = width/2;
        if(pos.z > height/2)  pos.z = -height/2;
        if(pos.z < -height/2) pos.z = height/2;

        //2D movement, position should always = 0 on y-axis
        if(pos.y!=0) pos.y = 0;
        this->setPosition(pos);


        //if you hit an asteroid, the ship will turn -> you need to reorientate the ship 
        Quaternion ort = this->getOrientation();
        ort.x = 0;
        ort.z = 0;
        this->setOrientation(ort);
    }

    void Asteroids2DShip::boost(bool bBoost)
    {
    }

    void Asteroids2DShip::updateLevel()
    {
        if (getGame())
            getGame()->levelUp();
    }

    inline bool Asteroids2DShip::collidesAgainst(WorldEntity* otherObject, const btCollisionShape* ownCollisionShape, btManifoldPoint& contactPoint)
    {

        Asteroids2DStone* stone = orxonox_cast<Asteroids2DStone*>(otherObject);       
        if(stone != nullptr && !bImmune)
        {
            removeHealth(100); 
            this->getGame()->addPoints(10);

            //The ship will be immune for 3 seconds after it has been hit by an asteroid
            bImmune = true;
            isimmune.setTimer(3.0f, false, createExecutor(createFunctor(&Asteroids2DShip::toggleImmune, this)));
        }
        return false;
    }

    Asteroids2D* Asteroids2DShip::getGame()
    {
        if (game == nullptr)
        {
            for (Asteroids2D* race : ObjectList<Asteroids2D>())
            {
                game = race;
            }
        }
        return game;
    }

    void Asteroids2DShip::death()
    {
        getGame()->costLife();
        SpaceShip::death();
    }
}
