#include "PacmanRed.h"

#include "core/CoreIncludes.h"
#include "BulletDynamics/Dynamics/btRigidBody.h"



	namespace orxonox{

		RegisterClass(PacmanRed);

		PacmanRed::PacmanRed(Context* context) : PacmanGhost(context){

        RegisterObject(PacmanRed);
        this->target_x=0;
        this->target_z=15;
        this->lastPlayerPassedPoint=Vector3(0,0,0); 
        this->isNearPlayer=false;
          
    }


    /**
    @brief
        Method for creating a ghost through XML.
    */
    void PacmanRed::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(PacmanRed, XMLPort, xmlelement, mode);
    }

    void PacmanRed::tick(float dt)
    {
        SUPER(PacmanGhost, tick, dt);

        this->actuelposition = this->getPosition();

        for(int u=0; u < 67; u++){//always check if player passed a point
            
                if(jeanfindpos(this->getPlayerPos(), possibleposition[u])){
                    
                this->lastPlayerPassedPoint=possibleposition[u];
                            }    
            }

        //Stop, if target arrived
        if((abs(this->actuelposition.x - this->target_x)<0.5) && (abs(this->actuelposition.z - this->target_z)<0.5)){
            
                 this->ismoving = false;
        }

        //Move, if ghost hasn't arrived yet
        if(this->ismoving){
            
            if(!(abs(this->actuelposition.z-target_z)<0.5)) {
                velocity = Vector3(0,0,-sgn(this->actuelposition.z-this->target_z));
                move(dt, actuelposition, velocity);
            }    
            if(!(abs(this->actuelposition.x-target_x)<0.5)){
                velocity = Vector3(-sgn(this->actuelposition.x-this->target_x),0,0);
                move(dt, actuelposition, velocity);
            }
        
        }
        else if(this->lastPlayerPassedPoint==Vector3(0,0,0)){
            //as long as the player has not started the game,
            //i.e. lastPlayerPastPoint is (0,0,0), red pacman
            //cannot possibly move, because it needs the position
            //of the player to move accordingly

            this->ismoving=false;
        }

        //Check on which position the ghost has arrived and set new target
        else{

            while(lockmove){};
            lockmove = true;

        	//do red behavior
            //Use target_x and target_z for position of red pacman

            Vector3 redPos=Vector3(this->target_x, 10, this->target_z);
            this->pointInFrontOfPlayer=frontPosition(); 

            if(!findpos(this->actuelposition, lastPlayerPassedPoint)){
                
            nextMove(redPos, lastPlayerPassedPoint);
            }
            else if(findpos(this->actuelposition, lastPlayerPassedPoint)){// red pacman is at lastPlayerPassedPoint

            nextMove(lastPlayerPassedPoint, pointInFrontOfPlayer); 
            }

            lockmove=false; //NEVER FORGET THIS ONE !!!!!!!
        }
        
    }


	void PacmanRed::nextMove( Vector3 redPosP, Vector3 playerPos){
	
        Vector3 nextTarget;

        if(redPosP!=playerPos){
	   nextTarget = getShortestPath(redPosP, playerPos);
       setNewTargetGhost(nextTarget);
        }
	}

}