/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Marc Dreher
 *   Co-authors:
 *      
 *
 */

#include "PacmanPointSphere.h"

#include "core/CoreIncludes.h"
#include "BulletDynamics/Dynamics/btRigidBody.h"

namespace orxonox
{
    RegisterClass(PacmanPointSphere);

    /**
    @brief
        Constructor. Registers the object and initializes some default values.
    @param creator
        The creator of this object.
    */
    PacmanPointSphere::PacmanPointSphere(Context* context) : ControllableEntity(context)
    {
        RegisterObject(PacmanPointSphere);
        this->setCollisionType(CollisionType::None);
    }

    /**
    @brief
        Destructor. Destroys controller, if present.
    */
    PacmanPointSphere::~PacmanPointSphere()
    {
        // Deletes the controller if the object was initialized and the pointer to the controller is not NULL.
    }

    /**
    @brief
        Method for creating a AutonomousDrone through XML.
    */
    void PacmanPointSphere::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(PacmanPointSphere, XMLPort, xmlelement, mode);
    }


    void PacmanPointSphere::tick(float dt)
    {
        SUPER(PacmanPointSphere, tick, dt);
    }

    //Check for collision
    bool PacmanPointSphere::taken(Vector3 playerpos)
    {
        resetposition = this->getPosition();
      if((abs(this->resetposition.x - playerpos.x)<10) && (abs(this->resetposition.y - playerpos.y)<10) && (abs(this->resetposition.z - playerpos.z)<5)){
        this->setPosition(Vector3(resetposition.x, -50, resetposition.z));
        return true;
      } 
      return false;
    }
    //Reset position
    void PacmanPointSphere::resetPacmanPointSphere(){
        resetposition = this->getPosition();
        resetposition.y = 10;
        this->setPosition(resetposition);
    }
}
