	
#include "PacmanPink.h"

#include "core/CoreIncludes.h"
#include "BulletDynamics/Dynamics/btRigidBody.h"

	
namespace orxonox{

	RegisterClass(PacmanPink);

		PacmanPink::PacmanPink(Context* context) : PacmanGhost(context){

        RegisterObject(PacmanPink);

        this->target_x=0;
        this->target_z=15;
        this->lastPlayerPassedPoint=Vector3(0,0,0); 
        this->pointInFrontOfPlayer=Vector3(0,0,0);
          
    }

    /**
    @brief
        Method for creating a ghost through XML.
    */
    void PacmanPink::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(PacmanPink, XMLPort, xmlelement, mode);
    }


    void PacmanPink::tick(float dt)
    {
        SUPER(PacmanGhost, tick, dt);
        this->actuelposition = this->getPosition();

        for(int u=0; u < 67; u++){//always check if player passed a point
            if(jeanfindpos(this->getPlayerPos(), possibleposition[u])){ 
                    this->lastPlayerPassedPoint=possibleposition[u];        
                }
            }

        this->pointInFrontOfPlayer=frontPosition(); 
        Vector3 pinkPos=Vector3(this->target_x, 10, this->target_z);
        
        //Stop, if target arrived
        if((abs(this->actuelposition.x - this->target_x)<0.5) && (abs(this->actuelposition.z - this->target_z)<0.5)){
                 this->ismoving = false;
        }

        //Move, if ghost hasn't arrived yet
        if(this->ismoving){
            if(!(abs(this->actuelposition.z-target_z)<0.5)) {
                velocity = Vector3(0,0,-sgn(this->actuelposition.z-this->target_z));
                move(dt, actuelposition, velocity);
            }    
            if(!(abs(this->actuelposition.x-target_x)<0.5)){
                velocity = Vector3(-sgn(this->actuelposition.x-this->target_x),0,0);
                move(dt, actuelposition, velocity);
            }
        }
        else if(this->lastPlayerPassedPoint==Vector3(0,0,0)){
            //as long as the player has not started the game,
            //i.e. lastPlayerPastPoint is (0,0,0), pink pacman
            //cannot possibly move, because it needs the position
            //of the player to move accordingly

            this->ismoving=false;
        }
        else if(this->pointInFrontOfPlayer==Vector3(0,0,0)){

            Vector3 pinkPos=Vector3(this->target_x, 10, this->target_z);
            setNewTargetGhost(getShortestPath(pinkPos, this->lastPlayerPassedPoint));

        }
        //Check on which position the ghost has arrived and set new target
         else{
            while(lockmove){};
            lockmove = true;
            nextMove(pinkPos, pointInFrontOfPlayer, lastPlayerPassedPoint);
            lockmove=false;
        }
	}



    void PacmanPink::nextMove( Vector3 pinkPosP, Vector3 playerPos, Vector3 pointToAvoidP11){
    
        Vector3 nextTarget;

        if(playerPos==pointToAvoidP11){ //SIGSEV if playerPos==pointToAvoidP11 otherwise
            nextTarget = getShortestPath(pinkPosP, playerPos);
        }
        else if(playerPos==Vector3(-70,10,-35)){
            
        nextTarget=getShortestPath(pinkPosP, Vector3(-70,10,-35));
        
        }
        else{   
        
        nextTarget = getShortestPath(pinkPosP, playerPos, pointToAvoidP11);
        }
        
       setNewTargetGhost(nextTarget);
    }

}

	

	
