/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Marc Dreher
 *   Co-authors:
 *      ..
 *
 */

#ifndef _PacmanGhost_H__
#define _PacmanGhost_H__

#include "OrxonoxPrereqs.h"

#include "core/XMLPort.h"

#include "worldentities/ControllableEntity.h"

#include "Pacman.h"

namespace orxonox {

    extern Vector3 possibleposition[67];

    extern bool findpos(Vector3 one, Vector3 other);





    class _OrxonoxExport PacmanGhost : public ControllableEntity
    {
        public:
            PacmanGhost(Context* context);
            virtual ~PacmanGhost();

            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode) ; //!< Method for creating an AutonomousDrone through XML.
            //virtual void tick(float dt); //!< Defines which actions the AutonomousDrone has to take in each tick.

            virtual void move(float dt, Vector3 actuelposition, Vector3 velocity);
            
            virtual void resetGhost();

            virtual void changewith(PacmanGhost* otherghost);
            virtual void levelupvelo();
      
            virtual void changemovability();
            bool dontmove = false;

       
            int decision = 0; 
            Vector3 resetposition = Vector3(0,10,15);
            Vector3 velocity;
            int speed = 20;

            Vector3 actuelposition;
            bool ismoving = false;
            int target_x = 0; 
            int target_z = 0;
            bool lockmove = false;


        Vector3 getPlayerPos();

        Vector3 playerPos;

        Vector3 lastPlayerPassedPoint;

        Vector3 pointInFrontOfPlayer;
        
        /*
    public: //HACK
    */


    struct graphVertex;
    void findNeighboorVertices(Vector3 actuelposition, graphVertex* adjacentVertices[], graphVertex listOfVerticesP2[]);
    void updateShortestDistanceToStart(graphVertex &vertex, graphVertex &neighboor);
    void findNearestNonVisitedNeighboor (graphVertex &vertex, Vector3 pointToAvoidP3=Vector3(0,0,0));
    int graphDistance(Vector3 start, Vector3 goal);

    graphVertex* findNextVertexToConsider(graphVertex listOfVerticesP[], Vector3 pointToAvoidP2=Vector3(0,0,0));
    Vector3 getShortestPath(Vector3 start, Vector3 goal, Vector3 pointToAvoidP1=Vector3(0,0,0));



    Vector3 getPointInFrontOfPacman(Vector3 pacLasVisPos,int indexForSWNE);
    int findPlayerTravDir (Vector3 playerPosBefore, Vector3 playerPos);
    Vector3 diffVector (Vector3 start, Vector3 goal);

    bool playerFindPos(Vector3 one, Vector3 other);

    bool jeanfindpos(Vector3 one, Vector3 other);

    void setNewTargetGhost(Vector3 goalToGo);





    void findNeighboorPositions(Vector3 actuelposition, Vector3 adjacentPositions[], Vector3 positionArray[]);

    Vector3 frontPosition();

    };

}

#endif