#include "PacmanCyan.h"
//#include "Pacman.h"

#include "core/CoreIncludes.h"
#include "BulletDynamics/Dynamics/btRigidBody.h"

	namespace orxonox{

		RegisterClass(PacmanCyan);

		PacmanCyan::PacmanCyan(Context* context) : PacmanGhost(context){

        RegisterObject(PacmanCyan);
        this->target_x=0;
        this->target_z=15;
        this->setPosition(Vector3(0,10,15));
        this->lastPlayerPassedPoint=Vector3(70,10,-135);

        this->isPatrolling = false;
          
    }


    /**
    @brief
        Method for creating a ghost through XML.
    */
    void PacmanCyan::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(PacmanCyan, XMLPort, xmlelement, mode);
    }



    void PacmanCyan::tick(float dt)
    {
        
        SUPER(PacmanGhost, tick, dt);
        this->actuelposition = this->getPosition();

        //Stop, if target arrived
        if((abs(this->actuelposition.x - this->target_x)<0.5) && (abs(this->actuelposition.z - this->target_z)<0.5)){
            
                 this->ismoving = false;
        }

        //Move, if ghost hasn't arrived yet
        if(this->ismoving){     
            if(!(abs(this->actuelposition.z-target_z)<0.5)) {
                velocity = Vector3(0,0,-sgn(this->actuelposition.z-this->target_z));
                move(dt, actuelposition, velocity);
            }    
            if(!(abs(this->actuelposition.x-target_x)<0.5)){
                velocity = Vector3(-sgn(this->actuelposition.x-this->target_x),0,0);
                move(dt, actuelposition, velocity);
            }    
        }

        //Check on which position the ghost has arrived and set new target
        else{
            while(lockmove){};
            lockmove = true;

            Vector3 cyanPos=Vector3(this->target_x, 10, this->target_z);
        	
            if(this->isPatrolling==false){
                //we are not patrolling anymore, choose new patrol


                this->nextPatrol();

            }
            else if(this->passedByStart==false){
                //we have not even reached our startPatrol point

                if(findpos(cyanPos, startPatrol)){
                    this->passedByStart=true;
                }
                else{
                nextMove(cyanPos, startPatrol);
                }
            }
            else if(this->passedByGoal==false){
                //we have reached our startPatrol point, now we go to goalPoint

                if(findpos(cyanPos, goalPatrol)){
                    this->passedByGoal=true;
                }
                else{
                nextMove(cyanPos, goalPatrol);
                }

            }
            else if(!findpos(cyanPos, this->startPatrol)){
                //we reached our goal, now we return to start

                nextMove(cyanPos, startPatrol);

            }
            else {
                //we reached startPoint again. Either we change patrol
                //or redo same patrol

                int redoORNot = rand()%2;

                if(redoORNot==1){

                this->isPatrolling=false;
                //we will change patrol region
                    }
                else {
                this->passedByGoal=false;
                //repeat patrol region
                    }
            }

            lockmove=false; //NEVER FORGET THIS ONE !!!!!!!
        }
        
    }

    void PacmanCyan::nextPatrol(){

                int indexRand1=rand()%67;
                while(indexRand1==44){
                    //new try if index is that of the position in the middle
                    indexRand1=rand()%67;
                }

                int indexRand2=rand()%67;
                while((indexRand2==44)||(indexRand2==indexRand1)){
                    //new try if 2nd index is same as first one or is index
                    // of position in the middle

                    indexRand2=rand()%67;
                }

              this->startPatrol =  possibleposition[indexRand1];
              this->goalPatrol = possibleposition[indexRand2];

              this->passedByStart=false;
              this->passedByGoal=false;
              this->isPatrolling=true;

    }




	void PacmanCyan::nextMove( Vector3 cyanPosP, Vector3 playerPos){

	   Vector3 nextTarget = getShortestPath(cyanPosP, playerPos);
	
	   setNewTargetGhost(nextTarget);
	}


}