#ifndef _PacmanBrown_H__
#define _PacmanBrown_H__

#include "PacmanGhost.h"

namespace orxonox {

	class _OrxonoxExport PacmanBrown : public PacmanGhost{

		public :
			PacmanBrown(Context* context);

			  virtual void tick(float dt) override; //!< Defines which actions the AutonomousDrone has to take in each tick.

  			virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode) override;

  			void setNewTargetBrown(Vector3 goalToGo);

  			void nextMove(Vector3 playerPos, Vector3 redPos);

  			int graphDistance(Vector3 start, Vector3 goal);

  			int absoluteDistance(Vector3 pos1, Vector3 pos2);

  			void fleeMode();


  			Vector3 goAdjacentOfPlayer(Vector3 neighboorsOfPlayer[]);
  			//they both do the same -_-
  			Vector3 findPlayerNeighboorNearestToPacman(Vector3 neighboorArray);

        bool isFleeing;

        bool isAdjacentToPlayerLastPastPoint(Vector3 pacmanBrownPos, Vector3 arrayForNeighborPositions[]);

	};

}

#endif 