	
#include "PacmanBrown.h"

#include "core/CoreIncludes.h"
#include "BulletDynamics/Dynamics/btRigidBody.h"

	
	namespace orxonox{

		RegisterClass(PacmanBrown);

		PacmanBrown::PacmanBrown(Context* context) : PacmanGhost(context){

        RegisterObject(PacmanBrown);

        this->target_x=0;
        this->target_z=15;
        this->lastPlayerPassedPoint=Vector3(0,0,0); 
          
    }

    /**
    @brief
        Method for creating a ghost through XML.
    */
    void PacmanBrown::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(PacmanBrown, XMLPort, xmlelement, mode);
    }


int PacmanBrown::absoluteDistance(Vector3 pos1, Vector3 pos2){


        Vector3 diffVector;
        diffVector.x=pos2.x-pos1.x;
        diffVector.y=pos2.y-pos1.y; //should always be 0
        diffVector.z=pos2.z-pos1.z;
        int result = sqrt((diffVector.x)*(diffVector.x)+(diffVector.z)*(diffVector.z));
        return result;
    }


	void PacmanBrown::tick(float dt)
    {
        SUPER(PacmanGhost, tick, dt);

        this->actuelposition = this->getPosition();


        for(int u=0; u < 67; u++){//always check if player passed a point
            if(jeanfindpos(this->getPlayerPos(), possibleposition[u])){
            this->lastPlayerPassedPoint=possibleposition[u];
                    }
            }

        
        //Stop, if target arrived
        if((abs(this->actuelposition.x - this->target_x)<0.5) && (abs(this->actuelposition.z - this->target_z)<0.5)){
                 this->ismoving = false;
        }

        //Move, if ghost hasn't arrived yet
        if(this->ismoving){
            if(!(abs(this->actuelposition.z-target_z)<0.5)) {
                velocity = Vector3(0,0,-sgn(this->actuelposition.z-this->target_z));
                move(dt, actuelposition, velocity);
            }    
            if(!(abs(this->actuelposition.x-target_x)<0.5)){
                velocity = Vector3(-sgn(this->actuelposition.x-this->target_x),0,0);
                move(dt, actuelposition, velocity);
            }
        }
        else if(this->lastPlayerPassedPoint==Vector3(0,0,0)){
            //as long as the player has not started the game,
            //i.e. lastPlayerPastPoint is (0,0,0), brown pacman
            //cannot possibly move, because it needs the position
            //of the player to move accordingly

            this->ismoving=false;
        }
        
        //Check on which position the ghost has arrived and set new target
        else{
        	while(lockmove){};
            lockmove = true;

        	//do brown behavior
        	//put everything needed here

            Vector3 brownPos=Vector3(this->target_x, 10, this->target_z);

            
            if(this->isFleeing==true){
                if(findpos(brownPos, Vector3(-215,10,-195))){
                    this->isFleeing=false;
                }
                else{
                    if(findpos(this->lastPlayerPassedPoint, Vector3(-215,10,-195))){
                    Vector3 nextMoveP = getShortestPath(brownPos, Vector3(-215,10,-195));
                    this->setNewTargetGhost(nextMoveP);
                    }
                    else{
                    Vector3 nextMoveP = getShortestPath(brownPos, Vector3(-215,10,-195), this->lastPlayerPassedPoint);
                    this->setNewTargetGhost(nextMoveP);
                    }
                }

            }
            else {
                    Vector3 arrayPlaNeig[4];

                    findNeighboorPositions(this->lastPlayerPassedPoint, arrayPlaNeig, possibleposition);
                    if(isAdjacentToPlayerLastPastPoint(brownPos, arrayPlaNeig)){
                        this->isFleeing=true;
                    }
                    else{
                        Vector3 nextMove = getShortestPath(brownPos, this->lastPlayerPassedPoint);        
                        setNewTargetGhost(nextMove);
                    }
                    
            }


            lockmove=false; //NEVER FORGET THIS ONE !!!
   
        }
}


    bool PacmanBrown::isAdjacentToPlayerLastPastPoint(Vector3 pacmanBrownPos, Vector3 arrayForNeighborPositions[]){
            //return true if brownPacman is on an adjacent position to the last
            //point visited by the player. return false otherwise.

            for(int i =0; i < 4; i++){
                if(arrayForNeighborPositions[i]!=Vector3(0,0,0)){
                    if(findpos(pacmanBrownPos, arrayForNeighborPositions[i])){
                        return true;
                    }
                }
            }
            return false;
        }



}

