/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Marc Dreher
 *   Co-authors:
 *      ...
 *
 */

/**
    @file DodgeRace.h
    @brief Gametype.
    @ingroup DodgeRace
*/

#ifndef _Pacman_H__
#define _Pacman_H__

#include "PacmanGelb.h"
#include "PacmanGhost.h"
#include "PacmanPointSphere.h"
#include "PacmanPointAfraid.h"
#include "PacmanLaser.h"

#include "core/EventIncludes.h"
#include "core/command/Executor.h"
#include "core/config/ConfigValueIncludes.h"

#include "gamestates/GSLevel.h"
#include "chat/ChatManager.h"
#include <vector>

// ! HACK
#include "infos/PlayerInfo.h"

#include "core/command/ConsoleCommand.h"

#include "gametypes/Deathmatch.h"
#include "tools/Timer.h"

namespace orxonox
{
    /*
deklaration ohne Speicher zu reservieren. definition in Pacman.cc
wird benoetigt um auf die Position global zuzugreifen

analog pacman_next

    */
    extern int PACMAN_INTERNAL_PACMAN_POSITION;

    class _PacmanExport Pacman : public Deathmatch
    {
       public:
            Pacman(Context* context);

            virtual void start() override;
            virtual void end() override;

            virtual void tick(float dt) override;

            PacmanGelb* getPlayer();
            int getPoints();
            bool getAfraid();
            int getTimer();
            int getLives();
            int getLevel();
            int getTotalpoints();
            bool isdead();
            
       private:

            void levelUp();
            bool collis(Vector3 one, Vector3 other);
            void catched(float dt);
            void posreset();
            void takePoint(PacmanPointSphere* taken);
            void setAfraid();
            void setNormal();
            void dead(float dt);

            PacmanGelb* player;
            Vector3 currentPosition;
            Vector3 startposplayer = Vector3(0,10,150);
            bool bcolli = false;
           
            int totallevelpoint;
            
            bool afraid = false;
            bool death = false;
            float deathtime = 0;
            float timer = 0;

            int level;
            int point;
            int lives;
            int laser;
        
    };
}

#endif /* _Pacman_H__ */