/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Marc Dreher
 *   Co-authors:
 *      ...
 *
 */

/**
    @file 3DPacman.cc
    @brief Implementation of the 3DPacman class.
*/

#include "Pacman.h"
#include "core/CoreIncludes.h"

namespace orxonox
{
    RegisterClass(Pacman);

    int PACMAN_INTERNAL_PACMAN_POSITION;

    Pacman::Pacman(Context* context) : Deathmatch(context)
    {
        RegisterObject(Pacman);

        lives = 3;
        point = 0;
        level = 1;
        laser = 5; //after that number of eaten pointSpheres, the laser appears

    }

    void Pacman::levelUp()
    {
        //Reset each object
        for(PacmanPointSphere* nextsphere : ObjectList<PacmanPointSphere>()){
        	nextsphere->resetPacmanPointSphere();
        }

        
        PacmanLaser* pos = *(ObjectList<PacmanLaser>().begin());
        pos->resetPacmanLaser();



        for(PacmanPointAfraid* next : ObjectList<PacmanPointAfraid>()){
            next->resetPacmanPointAfraid();
        }

        //Level up ghosts
        for(PacmanGhost* nextghost : ObjectList<PacmanGhost>()){
            nextghost->levelupvelo(); 
        }
        //Reset ghosts and player
        this->posreset();

        //Increase maximum of points and level
        totallevelpoint = ObjectList<PacmanPointSphere>().size() + totallevelpoint;
        level++;
    }


    PacmanGhost* ghosts[8];


    void Pacman::tick(float dt)
    {

        SUPER(Pacman, tick, dt);


        //Needed for gameover
        if(deathtime != 0){
            dead(dt);


         
        }

        //ingame loop
        else{

            //support by laser
            if(point > laser + 240*(level-1)){
              
                for(PacmanPointSphere* pointer : ObjectList<PacmanPointSphere>()){
                    Vector3 pointSpherePosition = pointer->getPosition();

                     if(pointSpherePosition.y > 0){// pointSphere above surface =not eaten yet

                        PacmanLaser* pos = *(ObjectList<PacmanLaser>().begin());
                        pos->setPosition(pointSpherePosition);
                        break;
                    }


                }

            }

            //Register ghosts
            int i = 0;
            for(PacmanGhost* nextghost: ObjectList<PacmanGhost>()){
                ghosts[i] = nextghost;
                i++;
            }
            //Switch ghost to not-catchable, if timer is zero
            if(afraid){
                timer = timer - dt;
                if(timer<=0){
                    setNormal();
                }
            }

            //Get position of player
            player = this->getPlayer();
            if (player != nullptr)
            {
                currentPosition = player->getWorldPosition();
            }

            //Check for collision with ghosts
            bcolli = false;
            for(int nrghost = 0; (nrghost<8) && (!bcolli); ++nrghost){
                bcolli = collis(ghosts[nrghost]->getPosition(), currentPosition);
            }

            if(bcolli){
                this->catched(dt);
            }

            //Check for collision with PointSpheres and PacmanPointAfraid
            for(PacmanPointSphere* nextsphere : ObjectList<PacmanPointSphere>()){
                 if(nextsphere->taken(currentPosition))
                    takePoint(nextsphere);
            }

            for(PacmanPointAfraid* next : ObjectList<PacmanPointAfraid>()){
                if(next->taken(currentPosition))
                  setAfraid();
            }

        } 

    }

    //Check for collisions between to objects (compare float numbers)
    bool Pacman::collis(Vector3 one, Vector3 other){
        if((abs(one.x-other.x)<19) && (abs(one.y-other.y)<10) && (abs(one.z-other.z)<19))
            return true;
        return false;
    }

    //Decrease live or resetghost
    void Pacman::catched(float dt){

    if(!this->afraid) {
        if(!this->lives){
          deathtime = 5;
          this->dead(dt);  
        }
        --lives;
        this->posreset();
        }
    else{
        for(int nrghost = 0; nrghost<8; ++nrghost){
            bcolli = collis(ghosts[nrghost]->getPosition(), currentPosition);
            if(bcolli) ghosts[nrghost]->resetGhost();
                bcolli = false;
        }
      }
    }

    //Change ghost design (to afraid)
    void Pacman::setAfraid(){

        timer = 10; //Set timer to 10 seconds

        //Change normal Ghosts with afraid ones
        if(!afraid){
            ghosts[0]->changewith(ghosts[4]);
            ghosts[1]->changewith(ghosts[5]);
            ghosts[2]->changewith(ghosts[6]);
            ghosts[3]->changewith(ghosts[7]);
        }

        afraid = true; 
    } 

    //Change ghost design (to not afraid)
    void Pacman::setNormal(){

        timer = 0;

        //Change normal Ghosts with afraid ones
            ghosts[4]->changewith(ghosts[0]);
            ghosts[5]->changewith(ghosts[1]);
            ghosts[6]->changewith(ghosts[2]);
            ghosts[7]->changewith(ghosts[3]);

        afraid = false; 
    } 

    //Reset ghosts and plazer
    void Pacman::posreset(){
        for(int i = 0; i<4; ++i){
            ghosts[i]->resetGhost();
        }
        player->setPosition(startposplayer);
    }

    //Collision with PointSphere
    void Pacman::takePoint(PacmanPointSphere* taken){
        ++point;
        
        if(point == totallevelpoint){ 
            this->levelUp();
            return;
        }
    }


    PacmanGelb* Pacman::getPlayer()
    {
        for (PacmanGelb* ship : ObjectList<PacmanGelb>())
        {
            return ship;
        }
        return nullptr;
    }

    //Getter
    bool Pacman::getAfraid(){
        return afraid;
    }
    //Getter
    int Pacman::getTimer(){
        return timer;
    }
    //Getter
    int Pacman::getLevel(){
        return level;
    }
    //Getter
    int Pacman::getPoints(){
        return point;
    }
    //Getter
    int Pacman::getLives(){
        return lives;
    }
    //Getter
    bool Pacman::isdead(){
        return death;
    }
    //Getter
    int Pacman::getTotalpoints(){
        return totallevelpoint;
    }


    void Pacman::start()
    {
        Deathmatch::start();

        //Hide afraided ghosts under map
        int i = 0;
        for(PacmanGhost* nextghost : ObjectList<PacmanGhost>()){
            if(3<i){ 
                nextghost->setPosition(0,-20,0);
                nextghost->dontmove =  true;
            };
            i++;
        }

        //Set maximum of points of first level
        totallevelpoint = ObjectList<PacmanPointSphere>().size();

    }

    void Pacman::dead(float dt){
        death = true;

        deathtime = deathtime-dt;

        if(deathtime<0)
            this->end();
    }

    void Pacman::end()
    {
        GSLevel::startMainMenu();
    }
}