/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Manuel Meier
 *   Co-authors:
 *      Cyrill Burgener
 *
 */

/**
    @file Hover.cc
    @brief Implementation of the Hover class. Sets up the whole Minigame
*/

#include "Hover.h"

#include "HoverOrigin.h"
#include "HoverWall.h"

#include "MazeGenerator.h"
#include "core/CoreIncludes.h"
#include "worldentities/pawns/Pawn.h"
#include "worldentities/pawns/ScriptableControllerDrone.h"
#include "worldentities/pawns/SpaceShip.h"

#include "tools/Timer.h"
#include "infos/Bot.h"
#include "worldentities/pawns/ModularSpaceShip.h"
#include "graphics/Model.h"




namespace orxonox
{
    RegisterUnloadableClass(Hover);

    Hover::Hover(Context* context) : Gametype(context)
    {
        RegisterObject(Hover);

        this->origin_ = nullptr;
        this->firstTick_ = true;

        this->setHUDTemplate("HoverHUD");
    }
    // void Hover::spawnZombie(std::string id)
    // {
    //     Identifier *identifier = ClassByString("SpaceShip");

    //       if(!identifier)
    //     {
    //         orxout(user_error) << "Script tried to spawn unknown object" << std::endl;
    //         return;
    //     }

    //     if(!identifier->isLoadable())
    //     {
    //         orxout(user_error) << "Script tried to spawn unloadable object" << std::endl;
    //         return;
    //     }
        
    
    //     WorldEntity *entity;
    //     Identifiable *obj = identifier->fabricate(this->controller_->getWorldEntityByID("Player")->getContext());



    //     orxout(user_status) << "First hit!" << std::endl;

    //    if(obj->isA(ClassIdentifier<WorldEntity>::getIdentifier()))
    //     {
    //         orxout(user_status) << "Is WorldEntity!" << std::endl;
    //         entity = orxonox_cast<WorldEntity*>(obj);
    //     }
    //     else if(obj->isA(ClassIdentifier<PlayerInfo>::getIdentifier()))
    //     {
    //         // TODO This does not work yet because somehow the controllable entity is not set
    //         // yet at this stage.
    // //        entity = orxonox_cast<PlayerInfo*>(obj)->getControllableEntity();

    //         orxout(user_status) << "Is PlayerInfo!" << std::endl;

    //         //use TEMPLATES in the map to define objects that are not present on the map yet
    //         return;
    //     }
    //     else
    //     {
    //         orxout(user_warning) << "Script tried to spawn an object that is neither a WorldEntity, nor a PlayerInfo" << std::endl;
            
    //         return;
    //     }
       
    //     if(entity->isA(ClassIdentifier<MobileEntity>::getIdentifier())) {
    //         orxout(user_status) << "Is MobileEntity!" << std::endl;
    //         this->controller_->registerMobileEntity(id, orxonox_cast<MobileEntity*>(entity));
    //     }

        

    //     if(entity->isA(ClassIdentifier<Pawn>::getIdentifier())) {
    //         orxout(user_status) << "Is Pawn!" << std::endl;
    //         this->controller_->registerPawn(id, orxonox_cast<Pawn*>(entity));
    //     }
        
    //     this->controller_->registerWorldEntity(id, orxonox_cast<WorldEntity*>(entity));


    //     ///////////////GOLD!!!!!!!!!!!!!!!////////////////////////
    //     Pawn* pawn = this->controller_->getPawnByID(id);

    //     //Attach to pawn
    //     SpaceShip* drone = new SpaceShip(pawn->getContext()); // this is neccessary because the projectiles fired need a valid creator for the particlespawner (when colliding against something)
        
    //     drone->addTemplate("spaceshipzombie"); //ScriptableControllerDroneTemplate spaceshipescort

    //     Vector3 spawnPosition = pawn->getWorldPosition() + Vector3(500,20,500);
    //     drone->setPosition(spawnPosition);
    // }

    void Hover::tick(float dt)
    {
        SUPER(Hover, tick, dt);

        if(this->firstTick_ && this->origin_)
        {
            this->firstTick_ = false;

            int numCells = this->origin_->getNumCells();
            int cellSize = this->origin_->getCellSize();
            int cellHeight = this->origin_->getCellHeight();

            MazeGenerator generator(numCells);
            generator.generateMaze();
            generator.renderMaze();

            int* levelcode = generator.getLevelcode();

            //Outer Walls
            for(int i = 0; i<numCells; i++){
                (new HoverWall(origin_->getContext()))->init(0,        i+1,      cellSize, cellHeight, 1);
                (new HoverWall(origin_->getContext()))->init(numCells, i+1,      cellSize, cellHeight, 1);
                (new HoverWall(origin_->getContext()))->init(i+1,      0,        cellSize, cellHeight, 2);
                (new HoverWall(origin_->getContext()))->init(i+1,      numCells, cellSize, cellHeight, 2);
            }

            //Generate inner Walls according to levelcode
            // for(int y=0; y<numCells; y++){
            //     for(int x=0; x<numCells; x++){
            //         switch(levelcode[ y * numCells + x ]){
            //             case 1: (new HoverWall(origin_->getContext()))->init(x+1, numCells-y, cellSize, cellHeight, 1);
            //                     break;
            //             case 3: (new HoverWall(origin_->getContext()))->init(x+1, numCells-y, cellSize, cellHeight, 1);
            //             case 2: (new HoverWall(origin_->getContext()))->init(x+1, numCells-y, cellSize, cellHeight, 0);
            //             default: break;
            //         }
            //     }   
            // }

            



            //Generate 5 flags randomly
            // for ( int i = 0; i < 5; i++ )
            // {
            //     HoverFlag* zombieship = new SpaceShip(origin_->getContext());
            //     flag->init(rand()%numCells, rand()%numCells, cellSize);
            //     flags_.push_back(flag);
            // }



        }//firsttick end

        // Check if ship collided with one of the flags
        // for ( unsigned int i = 0; i < flags_.size(); i++ ){
        //     if(flags_[i]->getCollided()){
        //         flags_[i]->destroyLater();
        //         flags_.erase (flags_.begin()+i);
        //     }
        // }
        // numberOfFlags_ = flags_.size();

        //Spawn Zombies
        //spawnZombie(z1);


    }
}
