/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Cyrill Burgener
 *
 */

/**
    @file HoverShip.h
    @brief Declaration of the HoverShip class.
*/

#ifndef _HoverShip_H__
#define _HoverShip_H__

#include "HoverPrereqs.h"

#include "worldentities/pawns/SpaceShip.h"

namespace orxonox
{
    class _HoverExport HoverShip : public SpaceShip
    {
        public:
            HoverShip(Context* context);

            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode) override;

            /// sets this ships jumpBoost
            inline void setJumpBoost(float jumpBoost)
                { this->jumpBoost_ = jumpBoost; }
            /// returns this ships jumpBoost
            inline float getJumpBoost() const
                { return this->jumpBoost_; }

            /////moves slightly right and left, that zombieship approaches
            // virtual void leftright(const Vector2& value);

            virtual void moveFrontBack(const Vector2& value) override;

            virtual void moveRightLeft(const Vector2& value) override;

            virtual void moveUpDown(const Vector2& value) override;

            virtual void rotateYaw(const Vector2& value) override;

            virtual void rotatePitch(const Vector2& value) override;

            virtual void rotateRoll(const Vector2& value) override;

            virtual bool collidesAgainst(WorldEntity* otherObject, const btCollisionShape* cs, btManifoldPoint& contactPoint) override;

            virtual void boost(bool bBoost) override;

        private:
            float jumpBoost_;
            bool isFloor_;
    };
}

#endif /* _HoverShip_H__ */
