#include "PacmanLaser.h"

#include "core/CoreIncludes.h"
#include "BulletDynamics/Dynamics/btRigidBody.h"

namespace orxonox
{
    RegisterClass(PacmanLaser);

    /**
    @brief
        Constructor. Registers the object and initializes some default values.
    @param creator
        The creator of this object.
    */
    PacmanLaser::PacmanLaser(Context* context) : ControllableEntity(context)
    {
        RegisterObject(PacmanLaser);
        this->setCollisionType(CollisionType::None);
    }

    /**
    @brief
        Destructor. Destroys controller, if present.
    */
    PacmanLaser::~PacmanLaser()
    {
        // Deletes the controller if the object was initialized and the pointer to the controller is not NULL.
    }

    /**
    @brief
        Method for creating a AutonomousDrone through XML.
    */
    void PacmanLaser::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(PacmanLaser, XMLPort, xmlelement, mode);
    }


    void PacmanLaser::tick(float dt)
    {
        SUPER(PacmanLaser, tick, dt);
    }

    void PacmanLaser::resetPacmanLaser(){
    	resetposition = this->getPosition();
        resetposition.y = -50;
        this->setPosition(resetposition);
    }
}