#include "mousegametype.h"
namespace orxonox
{
RegisterUnloadableClass(MouseGametype);
MouseGametype::MouseGametype(Context* context):Gametype(context)
{
    RegisterObject(MouseGametype);
    player_ =nullptr;

}

void MouseGametype::start(){

    bool temp = this->bForceSpawn_;
    this->bForceSpawn_ = true;

    // Call start for the parent class.
    Gametype::start();

    // Reset the variable.
    this->bForceSpawn_ = temp;
}

void MouseGametype::spawnPlayersIfRequested()
{
    // Spawn a human player.
    for (const auto& mapEntry : this->players_)
        if (mapEntry.first->isHumanPlayer() && (mapEntry.first->isReadyToSpawn() || this->bForceSpawn_))
            this->spawnPlayer(mapEntry.first);
}


void MouseGametype::spawnPlayer(PlayerInfo* player)
{
    assert(player);

    if(this->player_ == nullptr)
    {
        this->player_ = player;
        this->players_[player].state_ = PlayerState::Alive;

    }
}

}
