#ifndef MOUSEAPI_H
#define MOUSEAPI_H


#include "OrxonoxPrereqs.h"
#include "util/OgreForwardRefs.h"
#include "graphics/Camera.h"
#include <util/Math.h>
#include <list>
#include <core/input/InputHandler.h>
#include <graphics/Camera.h>
#include <core/GraphicsManager.h>
#include <core/input/InputState.h>
#include <OgreCamera.h>
#include <OgreViewport.h>
#include "CameraManager.h"
#include <functional>
#include "core/GUIManager.h"
#include "core/input/KeyBinderManager.h"

namespace orxonox
{

typedef uint ClickableObjectID;
typedef uint ScrollableElementID;

class MouseAPI : public InputHandler, public Singleton<MouseAPI>
{
friend class Singleton<MouseAPI>;
private:

    struct clickableElement
    {
        ClickableObjectID id;
        Vector3 position;
        float radius;
        std::list<MouseButtonCode::ByEnum> buttons;
        std::function<void(MouseButtonCode::ByEnum button)> onClickedFunction;
        clickableElement(ClickableObjectID id,const Vector3& position,float radius,const std::list<MouseButtonCode::ByEnum>& buttons,std::function<void(MouseButtonCode::ByEnum button)> onClickedFunction):id(id),position(position),
            radius(radius), buttons(buttons), onClickedFunction(onClickedFunction){}
    };

    struct scrollElement
    {
        ScrollableElementID id;
        bool considerPosition;
        Vector3 position;
        float radius;
        std::function<void(int abs,int rel,const IntVector2& mousePos)> onScrolledFunction;
        scrollElement(ScrollableElementID id,std::function<void(int abs,int rel,const IntVector2& mousePos)> onScrolledFunction):id(id),considerPosition(false),
            onScrolledFunction(onScrolledFunction){}
        scrollElement(ScrollableElementID id,const Vector3& position, float radius, std::function<void(int abs,int rel,const IntVector2& mousePos)> onScrolledFunction):id(id),considerPosition(true),
            position(position), radius(radius), onScrolledFunction(onScrolledFunction){}
    };

    static MouseAPI* singletonPtr_s;
    std::list<clickableElement> clickEvents;
    std::list<scrollElement> scrollEvents;
    Ogre::Camera *cam ;
    //IntVector2 mousePos;
    InputState* state;
    bool active = false;



public:

    MouseAPI();
    ~MouseAPI();
    virtual void buttonPressed (MouseButtonCode::ByEnum button) override;
    virtual void buttonReleased(MouseButtonCode::ByEnum button)  override{}
    virtual void buttonHeld    (MouseButtonCode::ByEnum button) override{}
    virtual void mouseMoved    (IntVector2 abs, IntVector2 rel, IntVector2 clippingSize) override;
    virtual void mouseScrolled (int abs, int rel) override;

    ClickableObjectID addClickableObject(const Vector3& position,float radius,const std::list<MouseButtonCode::ByEnum>& buttons,std::function<void(MouseButtonCode::ByEnum button)>  onClickedFunction);
    ScrollableElementID addScrollElement(const Vector3& position,float radius,std::function<void(int abs,int rel,const IntVector2& mousePos)> onScrolledFunction);
    ScrollableElementID addScrollElement(std::function<void(int abs,int rel,const IntVector2& mousePos)> onScrolledFunction);

    //true: success; false: element not found
    bool changePositionOfClickableObject(ClickableObjectID id,const Vector3& position);
    bool changePositionOfScrollableElement(ScrollableElementID id,const Vector3& position);
    bool changeRadiusOfClickableObject(ClickableObjectID id,float radius);
    bool changeRadiusOfScrollableElement(ScrollableElementID id,float radius);
    bool deleteClickableObject(ClickableObjectID id);
    bool deleteScrollableElement(ScrollableElementID id);

    float getRadiusClick(ClickableObjectID id);
    float getRadiusScroll(ScrollableElementID id);

    Vector2 getMousePosition();

    void activate();
    static bool isActive(){return singletonPtr_s != nullptr && getInstance().active;}
    void deactivate();
};
}
#endif // MOUSEAPI_H
