#include "mouseapi.h"
#include "core/singleton/ScopedSingletonIncludes.h"
namespace orxonox{

ManageScopedSingleton(MouseAPI, ScopeID::GRAPHICS, false);

MouseAPI::MouseAPI()
{

}

void MouseAPI::activate()
{
    if(!active)
    {
        active = true;
        if(InputManager::exists())
        {
            //cam = CameraManager::getInstance().getActiveCamera()->getOgreCamera();
            state = InputManager::getInstance().createInputState("MouseAPI",true,true,99);
            state->setMouseExclusive(false);//does this work
            state->setMouseHandler(this);
            state->setKeyHandler(KeyBinderManager::getInstance().getDefaultAsHandler());
            InputManager::getInstance().enterState("guiMouseOnly");
            InputManager::getInstance().enterState("MouseAPI");
            InputManager::getInstance().setMouseExclusive("game",false);
            //InputManager::getInstance().setMouseExclusive("guiMouseOnly",false);
            //InputManager::getInstance().getState("game")->
        }
        //GUIManager::getInstance().showGUI("MouseAPICursor", true);//Display a mouse cursor by displaying a empty menu
    }

}

void MouseAPI::deactivate()
{
    if(active)
    {
        GUIManager::getInstance().showGUI("MouseAPICursor", true);
        active = false;
        if(InputManager::exists())
        {
            InputManager::getInstance().leaveState("MouseAPI");
            state->setMouseHandler(nullptr);
            InputManager::getInstance().destroyState("MouseAPI");
            InputManager::getInstance().enterState("game");
        }
        clickEvents.clear();
        scrollEvents.clear();
    }
}

MouseAPI::~MouseAPI()
{

}

void MouseAPI::buttonPressed(MouseButtonCode::ByEnum button)
{
    cam = CameraManager::getInstance().getActiveCamera()->getOgreCamera();//todo: trycatch
    Ogre::Viewport *vp = GraphicsManager::getInstance().getViewport();
    int mouseposX = InputManager::getInstance().getMousePosition().first;
    int mouseposY = InputManager::getInstance().getMousePosition().second;
    Ogre::Ray ray = cam->getCameraToViewportRay(mouseposX/((float)vp->getActualWidth()),mouseposY/((float)vp->getActualHeight()));
    for(auto event: clickEvents)
    {
        for(auto wantedButton:event.buttons)
        {
            Ogre::Sphere sphere(event.position,event.radius);
            if(wantedButton == button && ray.intersects(sphere).first && cam->isVisible(sphere))
                event.onClickedFunction(button);
        }
    }
}

void MouseAPI::mouseMoved(IntVector2 abs, IntVector2 rel, IntVector2 clippingSize)
{
    //mousePos = abs;
    InputManager::getInstance().leaveState("game");//hack: todo: crate 2nd input state with prioritz 98 for cegui(cursor)
    GUIManager::getInstance().showGUI("MouseAPICursor", true);//hack todo: only if gui not shown & evt better if not in mouse mooved
}

void MouseAPI::mouseScrolled(int abs, int rel)
{
    cam = CameraManager::getInstance().getActiveCamera()->getOgreCamera();
    Ogre::Viewport *vp = GraphicsManager::getInstance().getViewport();
    int mouseposX = InputManager::getInstance().getMousePosition().first;
    int mouseposY = InputManager::getInstance().getMousePosition().second;
    Ogre::Ray ray = cam->getCameraToViewportRay(mouseposX/((float)vp->getActualWidth()),mouseposY/((float)vp->getActualHeight()));
    for(auto event:scrollEvents)
    {
        if(!event.considerPosition || (ray.intersects(Ogre::Sphere(event.position,event.radius)).first && cam->isVisible(Ogre::Sphere(event.position,event.radius))))
            event.onScrolledFunction(abs,rel,IntVector2(mouseposX,mouseposY));
    }
}

ClickableObjectID MouseAPI::addClickableObject(const Vector3& position, float radius, const std::list<MouseButtonCode::ByEnum>& buttons, std::function<void(MouseButtonCode::ByEnum)> onClickedFunction)
{
    clickEvents.insert(clickEvents.begin(),{!clickEvents.empty() ? clickEvents.back().id + 1:0,position,radius,buttons,onClickedFunction});
    return clickEvents.back().id;
}
ScrollableElementID MouseAPI::addScrollElement(const Vector3& position, float radius, std::function<void(int abs,int rel,const IntVector2& mousePos)> onScrolledFunction)
{
    scrollEvents.insert(scrollEvents.begin(),{!scrollEvents.empty() ? scrollEvents.back().id + 1:0,position,radius,onScrolledFunction});
    return scrollEvents.back().id;
}
ScrollableElementID MouseAPI::addScrollElement(std::function<void(int abs,int rel,const IntVector2& mousePos)> onScrolledFunction)
{
    scrollEvents.insert(scrollEvents.begin(),{!scrollEvents.empty() ? scrollEvents.back().id + 1:0,onScrolledFunction});
    return scrollEvents.back().id;
}


bool MouseAPI::changePositionOfClickableObject(ClickableObjectID id,const Vector3& position)
{
    for(auto event:clickEvents)
    {
        if(event.id == id)
        {
            event.position = position;
            return true;
        }
    }
    return false;
}
bool MouseAPI::changePositionOfScrollableElement(ScrollableElementID id,const Vector3& position)
{
    for(auto event:scrollEvents)
    {
        if(event.id == id)
        {
            event.position = position;
            return true;
        }
    }
    return false;
}
bool MouseAPI::changeRadiusOfClickableObject(ClickableObjectID id,float radius)
{
    for(auto event = clickEvents.begin();event != clickEvents.end();event++ )
    {
        if(event->id == id)
        {
            event->radius = radius;
            return true;
        }
    }
    return false;
}
bool MouseAPI::changeRadiusOfScrollableElement(ScrollableElementID id,float radius)
{
    for(auto event = scrollEvents.begin();event != scrollEvents.end();event++ )
    {
        if(event->id == id)
        {
            event->radius = radius;
            return true;
        }
    }
    return false;
}
bool MouseAPI::deleteClickableObject(ClickableObjectID id)
{
    for(auto eventIt = clickEvents.begin();eventIt != clickEvents.end();eventIt++ )
    {
        if(eventIt->id == id)
        {
            clickEvents.erase(eventIt);
            return true;
        }
    }
    return false;
}
bool MouseAPI::deleteScrollableElement(ScrollableElementID id)
{
    for(auto eventIt = scrollEvents.begin();eventIt != scrollEvents.end();eventIt++ )
    {
        if(eventIt->id == id)
        {
            scrollEvents.erase(eventIt);
            return true;
        }
    }
    return false;
}

float MouseAPI::getRadiusClick(ClickableObjectID id)
{
     for(auto eventIt = clickEvents.begin();eventIt != clickEvents.end();eventIt++ )
     {
         if(eventIt->id == id)
         {
             return eventIt->radius;
         }
     }
     return 0;
}

float MouseAPI::getRadiusScroll(ScrollableElementID id)
{
     for(auto eventIt = scrollEvents.begin();eventIt != scrollEvents.end();eventIt++ )
     {
         if(eventIt->id == id)
         {
             return eventIt->radius;
         }
     }
     return 0;
}

//returns relative Position of the Mouse
Vector2 MouseAPI::getMousePosition()
{
    Ogre::Viewport *vp = GraphicsManager::getInstance().getViewport();
    return Vector2(InputManager::getInstance().getMousePosition().first/((float)vp->getActualWidth()),InputManager::getInstance().getMousePosition().second/((float)vp->getActualHeight()));
}

}
