#ifndef MOUSEAPIEXAMPLE_H
#define MOUSEAPIEXAMPLE_H

#include "core/XMLPort.h"
#include "mouseapi.h"
#include "core/CoreIncludes.h"
#include "worldentities/ControllableEntity.h"
#include <list>

namespace orxonox
{
class MouseAPIExample : public ControllableEntity
{
public:
    MouseAPIExample(Context *context);
    ~MouseAPIExample();
    virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode);
    void changesizeonclick(MouseButtonCode::ByEnum mouse);
    void changesizeonscroll(int abs,int rel,const IntVector2& mousePos);
    inline void setId(int id)
        { this->id = id; }
    inline int getId() const
        { return this->id; }
private:
    int id;
    ClickableObjectID cubeid;
    ScrollableElementID sphereid;
    static std::list<MouseAPIExample> blocks;
};
}
#endif // MOUSEAPIEXAMPLE_H
