#include "mouseapiexample.h"

namespace orxonox
{

RegisterClass(MouseAPIExample);

MouseAPIExample::MouseAPIExample(Context* context) : ControllableEntity(context)
{
    RegisterObject(MouseAPIExample);
}

MouseAPIExample::~MouseAPIExample()
{
    if(MouseAPI::isActive())
        MouseAPI::getInstance().deactivate();
}

// change the size of the cube by a random number between 0.5 and 5 by clicking on it
void MouseAPIExample::changesizeonclick(MouseButtonCode::ByEnum mouse)
{
    // generate random number between 0.5 and 5
    float randomnumber = (rand()%10+1)/2.0;
    // scale of the cube with this random number
    this->setScale(randomnumber);
    // change the radius of the clickableObject to the new size
    MouseAPI::getInstance().changeRadiusOfClickableObject(cubeid,randomnumber*10);
}

// change the size of the sphere by scrolling on it
void MouseAPIExample::changesizeonscroll(int abs,int rel,const IntVector2& mousePos)
{
    // get current radius of the sphere
    float curRadius = MouseAPI::getInstance().getRadiusScroll(sphereid);
    // set factor to 120% or 80% of the current size, depending on increase or decrease
    float factor = curRadius/10*(1+rel/600.0);
    //scale the sphere with this factor and change the radius
    this->setScale(factor);
    MouseAPI::getInstance().changeRadiusOfScrollableElement(sphereid,factor*10);
}

// standard XML-Port
void MouseAPIExample::XMLPort(Element& xmlelement, XMLPort::Mode mode)
{
    SUPER(MouseAPIExample, XMLPort, xmlelement, mode);

    // differentiate between several objects by an identifier "id"
    XMLPortParam(MouseAPIExample, "id", setId, getId, xmlelement, mode);
    if(this->getId() == 1) // id == 1; cube
    {
        // add the cube to the list with clickable Objects, set the radius to 10, define the function changesizeonclick to be called after a left-click
        cubeid = MouseAPI::getInstance().addClickableObject(this->getWorldPosition(),10,std::list<MouseButtonCode::ByEnum>{MouseButtonCode::Left},[this](MouseButtonCode::ByEnum mouse){this->changesizeonclick(mouse);});
    }
    else if(this->getId() == 2) // id == 2; sphere
    {
        // add the sphere to the list with scrollable Objects, set the radius to 10, define the function changesizeonscroll to be called while scrolling
        sphereid = MouseAPI::getInstance().addScrollElement(this->getWorldPosition(), 10, [this](int abs, int rel, const IntVector2& mousePos){this->changesizeonscroll(abs,rel,mousePos);});
    }

    // activate MouseAPI
    MouseAPI::getInstance().activate();
}
}
