#include "mouseapi.h"
#include "core/singleton/ScopedSingletonIncludes.h"
namespace orxonox{

ManageScopedSingleton(MouseAPI, ScopeID::GRAPHICS, false);

MouseAPI::MouseAPI()
{

}

void MouseAPI::activate()
{
    active = true;
     if(InputManager::exists())
     {
        //cam = CameraManager::getInstance().getActiveCamera()->getOgreCamera();
        state = InputManager::getInstance().createInputState("MouseAPI",true,true,99);
        state->setMouseExclusive(false);//does this work
        state->setMouseHandler(this);
        InputManager::getInstance().enterState("MouseAPI");
    }

}

void MouseAPI::deactivate()
{
    active = false;
    if(InputManager::exists())
    {
        InputManager::getInstance().leaveState("MouseAPI");
        state->setMouseHandler(nullptr);
        InputManager::getInstance().destroyState("MouseAPI");
    }
    clickEvents.clear();
    scrollEvents.clear();
}

MouseAPI::~MouseAPI()
{

}

void MouseAPI::buttonPressed(MouseButtonCode::ByEnum button)
{
    cam = CameraManager::getInstance().getActiveCamera()->getOgreCamera();//todo: trycatch
    Ogre::Viewport *vp = GraphicsManager::getInstance().getViewport();
    Ogre::Ray ray = cam->getCameraToViewportRay(mousePos.x/((float)vp->getActualWidth()),mousePos.y/((float)vp->getActualHeight()));
    for(auto event: clickEvents)
    {
        for(auto wantedButton:event.buttons)
        {
            if(wantedButton == button && ray.intersects(Ogre::Sphere(event.position,event.radius)).first)
                event.onClickedFunction(button);
        }
    }
}

void MouseAPI::mouseMoved(IntVector2 abs, IntVector2 rel, IntVector2 clippingSize)
{
    mousePos = abs;
}

void MouseAPI::mouseScrolled(int abs, int rel)
{
    cam = CameraManager::getInstance().getActiveCamera()->getOgreCamera();
    Ogre::Viewport *vp = GraphicsManager::getInstance().getViewport();
    Ogre::Ray ray = cam->getCameraToViewportRay(mousePos.x/((float)vp->getActualWidth()),mousePos.y/((float)vp->getActualHeight()));
    for(auto event:scrollEvents)
    {
        if(!event.considerPosition || ray.intersects(Ogre::Sphere(event.position,event.radius)).first)
            event.onScrolledFunction(abs,rel,mousePos);
    }
}

ClickableObjectID MouseAPI::addClickableObject(const Vector3& position, float radius, const std::list<MouseButtonCode::ByEnum>& buttons, std::function<void(MouseButtonCode::ByEnum)> onClickedFunction)
{
    clickEvents.insert(clickEvents.begin(),{!clickEvents.empty() ? clickEvents.back().id + 1:0,position,radius,buttons,onClickedFunction});
    return clickEvents.back().id;
}
ScrollableElementID MouseAPI::addScrollElement(const Vector3& position, float radius, std::function<void(int abs,int rel,const IntVector2& mousePos)> onScrolledFunction)
{
    scrollEvents.insert(scrollEvents.begin(),{!scrollEvents.empty() ? scrollEvents.back().id + 1:0,position,radius,onScrolledFunction});
    return scrollEvents.back().id;
}
ScrollableElementID MouseAPI::addScrollElement(std::function<void(int abs,int rel,const IntVector2& mousePos)> onScrolledFunction)
{
    scrollEvents.insert(scrollEvents.begin(),{!scrollEvents.empty() ? scrollEvents.back().id + 1:0,onScrolledFunction});
    return scrollEvents.back().id;
}


bool MouseAPI::changePositionOfClickableObject(ClickableObjectID id,const Vector3& position)
{
    for(auto event:clickEvents)
    {
        if(event.id == id)
        {
            event.position = position;
            return true;
        }
    }
    return false;
}
bool MouseAPI::changePositionOfScrollableElement(ScrollableElementID id,const Vector3& position)
{
    for(auto event:scrollEvents)
    {
        if(event.id == id)
        {
            event.position = position;
            return true;
        }
    }
    return false;
}
bool MouseAPI::changeRadiusOfClickableObject(ClickableObjectID id,float radius)
{
    for(auto event:clickEvents)
    {
        if(event.id == id)
        {
            event.radius = radius;
            return true;
        }
    }
    return false;
}
bool MouseAPI::changeRadiusOfScrollableElement(ScrollableElementID id,float radius)
{
    for(auto event:scrollEvents)
    {
        if(event.id == id)
        {
            event.radius = radius;
            return true;
        }
    }
    return false;
}
bool MouseAPI::deleteClickableObject(ClickableObjectID id)
{
    for(auto eventIt = clickEvents.begin();eventIt != clickEvents.end();eventIt++ )
    {
        if(eventIt->id == id)
        {
            clickEvents.erase(eventIt);
            return true;
        }
    }
    return false;
}
bool MouseAPI::deleteScrollableElement(ScrollableElementID id)
{
    for(auto eventIt = scrollEvents.begin();eventIt != scrollEvents.end();eventIt++ )
    {
        if(eventIt->id == id)
        {
            scrollEvents.erase(eventIt);
            return true;
        }
    }
    return false;
}

}
