/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Joel Smely
 *   Co-authors:
 *      ...
 *
 */

/**
    @file HoverGun.h
    @brief Definition of the HoverGun class.
*/

#ifndef _HoverGun_H__
#define _HoverGun_H__

#include "weapons/WeaponsPrereqs.h"
#include "weaponsystem/WeaponMode.h"

namespace orxonox
{

    /**
    @brief
        A slow ball of lightning.
    @author
        Joel Smely
    @ingroup WeaponsWeaponModes
    */
    class _WeaponsExport HoverGun : public WeaponMode
    {
        public:
            HoverGun(Context* context);
            virtual ~HoverGun();

            virtual void fire() override;

       private:
            float speed_; //!< The speed of the fired projectile.
    };
}

#endif /* _HoverGun_H__ */
