/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Joel Smely
 *   Co-authors:
 *      simonmie
 *
 */

/**
    @file HoverGun.h
    @brief Implementation of the HoverGun class.
*/

#include "HoverGun.h"

#include "core/CoreIncludes.h"
#include "weaponsystem/Weapon.h"
#include "weaponsystem/WeaponPack.h"
#include "weaponsystem/WeaponSystem.h"
#include "worldentities/pawns/Pawn.h"

#include "weapons/projectiles/HoverGunProjectile.h"

namespace orxonox
{
    RegisterClass(HoverGun);

    HoverGun::HoverGun(Context* context) : WeaponMode(context)
    {
        RegisterObject(HoverGun);

        this->reloadTime_ = 1.0f;
        this->damage_ = 0.0f;
        this->speed_ = 750.0f;

        this->setMunitionName("HoverMunition");
        this->setFireSound("sounds/Weapon_HoverGun.ogg");

        hudImageString_ = "Orxonox/WSHUD_WM_HoverGun";
    }

    HoverGun::~HoverGun()
    {
    }

    /**
    @brief
        Fires the weapon. Creates a projectile and fires it.
    */
    void HoverGun::fire()
    {
        HoverGunProjectile* projectile = new HoverGunProjectile(this->getContext());
        projectile->setMaterial("Flares/HoverBall_");

        this->computeMuzzleParameters(this->getWeapon()->getWeaponPack()->getWeaponSystem()->getPawn()->getAimPosition());
        projectile->setOrientation(this->getMuzzleOrientation());
        projectile->setPosition(this->getMuzzlePosition());
        projectile->setVelocity(this->getMuzzleDirection() * this->speed_);

        projectile->setShooter(this->getWeapon()->getWeaponPack()->getWeaponSystem()->getPawn());
        projectile->setDamage(this->getDamage());
        projectile->setShieldDamage(this->getShieldDamage());
        projectile->setHealthDamage(this->getHealthDamage());
    }
}
