#include "mouseapi.h"

namespace orxonox{

MouseAPI::MouseAPI()
{

}

void MouseAPI::activate()
{
     if(InputManager::exists())
     {
        //cam = CameraManager::getInstance().getActiveCamera()->getOgreCamera();
        state = InputManager::getInstance().createInputState("MouseAPI",true,true,99);
        state->setMouseExclusive(false);//does this work
        state->setMouseHandler(this);
        InputManager::getInstance().enterState("MouseAPI");
    }

}

void MouseAPI::deactivate()
{
    if(InputManager::exists())
    {
        InputManager::getInstance().leaveState("MouseAPI");
        state->setMouseHandler(nullptr);
        InputManager::getInstance().destroyState("MouseAPI");
    }
}

MouseAPI::~MouseAPI()
{

}

void MouseAPI::buttonPressed(MouseButtonCode::ByEnum button)
{
    cam = CameraManager::getInstance().getActiveCamera()->getOgreCamera();
    Ogre::Viewport *vp = GraphicsManager::getInstance().getViewport();
    Ogre::Ray ray = cam->getCameraToViewportRay(mousePos.x/((float)vp->getActualWidth()),mousePos.y/((float)vp->getActualHeight()));
    for(auto event: clickEvents)
    {
        for(auto wantedButton:event.buttons){
            if(wantedButton == button && ray.intersects(Ogre::Sphere(event.position,event.radius)).first)
                event.onClickedFunction(button);
        }
    }
}

void MouseAPI::mouseMoved(IntVector2 abs, IntVector2 rel, IntVector2 clippingSize)
{
    mousePos = abs;
}

void MouseAPI::mouseScrolled(int abs, int rel)
{
    Ogre::Viewport *vp = GraphicsManager::getInstance().getViewport();
    Ogre::Ray ray = cam->getCameraToViewportRay(mousePos.x/((float)vp->getActualWidth()),mousePos.y/((float)vp->getActualHeight()));
    for(auto event:scrollEvents){
        if(!event.considerPosition || ray.intersects(Ogre::Sphere(event.position,event.radius)).first)
            (*(event.onScrolledFunction))(abs,rel,mousePos);
    }
}

void MouseAPI::addClickableObject(const Vector3& position, float radius, const std::list<MouseButtonCode::ByEnum>& buttons, std::function<void(MouseButtonCode::ByEnum)> onClickedFunction)
{
    clickEvents.insert(clickEvents.begin(),{position,radius,buttons,onClickedFunction});
}
void MouseAPI::addScrollElement(const Vector3& position,float radius,void (*onScrolledFunction)(int abs,int rel,const IntVector2&  mousePos))
{
    scrollEvents.insert(scrollEvents.begin(),{position,radius,onScrolledFunction});
}
void MouseAPI::addScrollElement(void (*onScrolledFunction)(int abs,int rel,const IntVector2&  mousePos))
{
    scrollEvents.insert(scrollEvents.begin(),{onScrolledFunction});
}

void MouseAPI::changeCamera(Camera& camera)
{
    cam = camera.getOgreCamera();
}

}
