/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Hagen Seifert
 *   Co-authors:
 *      simonmie
 *
 */

/**
    @file HsW01.h
    @brief Implementation of the HsW01 class.
*/

#include "HoverGun.h"

#include "core/CoreIncludes.h"
#include "core/XMLPort.h"
#include "core/command/Executor.h"

#include "graphics/Model.h"
#include "weaponsystem/Weapon.h"
#include "weaponsystem/WeaponPack.h"
#include "weaponsystem/WeaponSystem.h"
#include "worldentities/WorldEntity.h"
#include "worldentities/pawns/Pawn.h"

#include "weapons/projectiles/HoverGunProjectile.h"
#include "weapons/MuzzleFlash.h"

namespace orxonox
{
    RegisterClass(HoverGun);

    HoverGun::HoverGun(Context* context) : WeaponMode(context)
    {
        RegisterObject(HoverGun);

        this->reloadTime_ = 0.25f;
        this->damage_ = 0.0f; //default 15
        this->speed_ = 750.0f;
        this->delay_ = 0.0f;
        this->setMunitionName("LaserMunition");
        this->mesh_ = "laserbeam.mesh";


        this->delayTimer_.setTimer(this->delay_, false, createExecutor(createFunctor(&HoverGun::shot, this)));
        this->delayTimer_.stopTimer();

        this->setFireSound("sounds/Weapon_HsW01.ogg");
        this->setReloadSound("sounds/Reload_HsW01.ogg", 0.5);

        hudImageString_ = "Orxonox/WSHUD_WM_HsW01";
    }

    HoverGun::~HoverGun()
    {
    }

    void HoverGun::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(HoverGun, XMLPort, xmlelement, mode);

        XMLPortParam(HoverGun, "delay", setDelay, getDelay, xmlelement, mode);
        XMLPortParam(HoverGun, "material", setMaterial, getMaterial, xmlelement, mode);
        XMLPortParam(HoverGun, "projectileMesh", setMesh, getMesh, xmlelement, mode);
        XMLPortParam(HoverGun, "sound", setSound, getSound, xmlelement, mode);
    }

    /**
    @brief
        Set the firing delay.
    @param delay
        The firing delay in seconds.
    */
    void HoverGun::setDelay(float delay)
    {
        this->delay_ = delay;
        this->delayTimer_.setInterval(this->delay_);
    }

    // void HoverGun::fire()
    // {
    //     this->delayTimer_.startTimer();
    // }

    /**
    @brief
        Fires the weapon. Creates a projectile and fires it.
    */
    void HoverGun::fire()
    {
        assert( this->getWeapon() && this->getWeapon()->getWeaponPack() && this->getWeapon()->getWeaponPack()->getWeaponSystem() && this->getWeapon()->getWeaponPack()->getWeaponSystem()->getPawn() );

        // Create the projectile.
        HoverGunProjectile* projectile = new HoverGunProjectile(this->getContext());
        Model* model = new Model(HoverGunprojectile->getContext());
        model->setMeshSource(mesh_);
        model->setCastShadows(false);
        projectile->attach(model);
        model->setScale(5);

        this->computeMuzzleParameters(this->getWeapon()->getWeaponPack()->getWeaponSystem()->getPawn()->getAimPosition());
        projectile->setOrientation(this->getMuzzleOrientation());
        projectile->setPosition(this->getMuzzlePosition());
        projectile->setVelocity(this->getMuzzleDirection() * this->speed_);

        projectile->setShooter(this->getWeapon()->getWeaponPack()->getWeaponSystem()->getPawn());
        projectile->setDamage(this->getDamage());
        projectile->setShieldDamage(this->getShieldDamage());
        projectile->setHealthDamage(this->getHealthDamage());

        // Display the muzzle flash.
        // this->HoverGun::muzzleflash();
    }

    /**
    @brief
        Displays the muzzle flash.
    */
    // void HoverGun::muzzleflash()
    // {
    //     MuzzleFlash *muzzleFlash = new MuzzleFlash(this->getContext());
    //     this->getWeapon()->attach(muzzleFlash);
    //     muzzleFlash->setPosition(this->getMuzzleOffset());
    //     muzzleFlash->setMaterial(this->material_);
    // }
}
