/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      simonmie
 *
 */

/**
    @file Projectile.h
    @brief Definition of the Projectile class.
*/

#ifndef _HoverGunProjectile_H__
#define _HoverGunProjectile_H__

#include "weapons/WeaponsPrereqs.h"

#include "tools/Timer.h"
#include "worldentities/MovableEntity.h"
#include "objects/collisionshapes/SphereCollisionShape.h"

#include "BasicProjectile.h"

namespace orxonox
{

    /**
    @brief
        Represents all 'standard' projectiles.

    @author
        Fabian 'x3n' Landau
    @author
        Simon Miescher
    @ingroup WeaponsProjectiles
    */
    class _WeaponsExport HoverGunProjectile : public MovableEntity, public BasicProjectile
    {
        public:
            HoverGunProjectile(Context* context);
            virtual ~HoverGunProjectile();

            void setConfigValues();

            virtual void tick(float dt) override;
            virtual bool collidesAgainst(WorldEntity* otherObject, const btCollisionShape* cs, btManifoldPoint& contactPoint) override;

        protected:
            virtual void setCollisionShapeRadius(float radius);
            float lifetime_; //!< The time the projectile exists.

        private:
            Timer destroyTimer_; //!< Timer to destroy the projectile after its lifetime has run out.
            WeakPtr<SphereCollisionShape> collisionShape_; // The collision shape of the projectile.
    };
}

#endif /* _Projectile_H__ */
