#ifndef MOUSEAPI_H
#define MOUSEAPI_H


#include "OrxonoxPrereqs.h"
#include "util/OgreForwardRefs.h"
#include "graphics/Camera.h"
#include <util/Math.h>
#include <list>
#include <core/input/InputHandler.h>
#include <graphics/Camera.h>
#include <core/GraphicsManager.h>
#include <core/input/InputState.h>
#include <OgreCamera.h>
#include <OgreViewport.h>
#include "CameraManager.h"
#include <functional>

namespace orxonox
{

class MouseAPI : public InputHandler
{

private:

    struct clickableElement
    {
        Vector3 position;
        float radius;
        std::list<MouseButtonCode::ByEnum> buttons;
        std::function<void(MouseButtonCode::ByEnum button)> onClickedFunction;
        clickableElement(const Vector3& position,float radius,const std::list<MouseButtonCode::ByEnum>& buttons,std::function<void(MouseButtonCode::ByEnum button)> onClickedFunction):position(position),
            radius(radius), buttons(buttons), onClickedFunction(onClickedFunction){}
    };

    struct scrollElement
    {
        bool considerPosition;
        Vector3 position;
        float radius;
        void (*onScrolledFunction)(int abs,int rel,const IntVector2& mousePos);
        scrollElement(void (*onScrolledFunction)(int abs,int rel,const IntVector2& mousePos)):considerPosition(false),
            onScrolledFunction(onScrolledFunction){}
        scrollElement(const Vector3& position, float radius, void (*onScrolledFunction)(int abs,int rel,const IntVector2& mousePos)):considerPosition(true),
            position(position), radius(radius), onScrolledFunction(onScrolledFunction){}
    };


    std::list<clickableElement> clickEvents;
    std::list<scrollElement> scrollEvents;
    Ogre::Camera *cam ;
    IntVector2 mousePos;
    InputState* state;


public:

    MouseAPI();
    ~MouseAPI();
    virtual void buttonPressed (MouseButtonCode::ByEnum button) override;
    virtual void buttonReleased(MouseButtonCode::ByEnum button)  override{}
    virtual void buttonHeld    (MouseButtonCode::ByEnum button) override{}
    virtual void mouseMoved    (IntVector2 abs, IntVector2 rel, IntVector2 clippingSize) override;
    virtual void mouseScrolled (int abs, int rel) override;

    void addClickableObject(const Vector3& position,float radius,const std::list<MouseButtonCode::ByEnum>& buttons,std::function<void(MouseButtonCode::ByEnum button)>  onClickedFunction);
    void addScrollElement(const Vector3& position,float radius,void (*onScrolledFunction)(int abs,int rel,const IntVector2&  mousePos));
    void addScrollElement(void (*onScrolledFunction)(int abs,int rel,const IntVector2&  mousePos));

    void changeCamera(Camera& camera);

    void activate();
    void deactivate();
};
}
#endif // MOUSEAPI_H
