#ifndef MOUSEAPI_H
#define MOUSEAPI_H

#include <util/Math.h>
#include <list>
#include <core/input/InputHandler.h>

namespace orxonox
{

class MouseAPI : public InputHandler
{

private:

    struct clickableElement
    {
        Vector3 position;
        float radius;
        list<ClickEvent> events;
        void (*onClickedFunction)();
        clickableElement(const Vector3& position,float radius,const list<ClickEvent>& events,void (*onClickedFunction)()):position(position),
            radius(radius), events(events), onClickedFunction(onClickedFunction){}
    };

    struct scrollElement
    {
        bool considerPosition;
        Vector3 position;
        float radius;
        void (*onScrolledFunction)(int abs,int rel,const IntVector2& mousePos);
        scrollEvents(void (*onScrolledFunction)(int abs,int rel,const IntVector2& mousePos)):considerPosition(false),
            onScrolledFunction(onScrolledFunction){}
        scrollEvents(Vector3& position, float radius, void (*onScrolledFunction)(int abs,int rel,const IntVector2& mousePos)):considerPosition(true),
            position(position), radius(radius), onScrolledFunction(onScrolledFunction){}
    };


    std::list<clickableElement> clickEvents;
    std::list<scrollElement> scrollEvents;


public:
    enum ClickEvent
    {
        rightClick,leftClick,middleCLick
    };

    MouseAPI();
    ~MouseAPI();
    virtual void buttonPressed (MouseButtonCode::ByEnum button);
    virtual void buttonReleased(MouseButtonCode::ByEnum button){}
    virtual void buttonHeld    (MouseButtonCode::ByEnum button){}
    virtual void mouseMoved    (IntVector2 abs, IntVector2 rel, IntVector2 clippingSize);
    virtual void mouseScrolled (int abs, int rel);

    void addClickableObject(const Vector3& position,float radius,const list<ClickEvent>& events,void (*onClickedFunction)());
    void addScrollElement(const Vector3& position,float radius,void (*onScrolledFunction)(int abs,int rel,const IntVector2&  mousePos));
    void addScrollElement(void (*onScrolledFunction)(int abs,int rel,const IntVector2&  mousePos));
};
}
#endif // MOUSEAPI_H
