/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Oliver Stadler
 *   Co-authors:
 *      ...
 *
 */

/**
@file
@brief
    Shared library macros, enums, constants and forward declarations for the questsystem module
*/

#ifndef _WagnisPrereqs_H__
#define _WagnisPrereqs_H__

#include "OrxonoxConfig.h"
#include "OrxonoxPrereqs.h"

//-----------------------------------------------------------------------
// Shared library settings
//-----------------------------------------------------------------------

#if defined(ORXONOX_PLATFORM_WINDOWS) && !defined(WAGNIS_STATIC_BUILD)
#  ifdef WAGNIS_SHARED_BUILD
#    define _WagnisExport __declspec(dllexport)
#  else
#    if defined( __MINGW32__ )
#      define _WagnisExport
#    else
#      define _WagnisExport __declspec(dllimport)
#    endif
#  endif
#elif defined ( ORXONOX_GCC_VISIBILITY )
#  define _WagnisExport  __attribute__ ((visibility("default")))
#else
#  define _WagnisExport
#endif

//-----------------------------------------------------------------------
// Forward declarations
//-----------------------------------------------------------------------

namespace orxonox
{

    class Wagnis;
    class WagnisProvince;
    class WagnisGameboard;
    class WagnisPlayer;
    class WagnisHUD;
    class WagnisHUDinfo;
    enum GameStage { NOT_READY, CHOOSE_PROVINCE_STAGE, REINFORCEMENT_STAGE, ATTACK_STAGE, MOVE_STAGE, WINNER_STAGE };
    enum MoveType { ATTACK, MOVE, SET_TROOPS, SET_TROOPS_INITIAL };

}

#endif /* _WagnisPrereqs_H__ */
