/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Roman Kunz
 *
 */

#include "WagnisHUDinfo.h"

#include "core/CoreIncludes.h"
#include "core/XMLPort.h"
#include "util/Convert.h"
#include <string>

namespace orxonox
{
    RegisterClass(WagnisHUDinfo);

    WagnisHUDinfo::WagnisHUDinfo(Context* context) : OverlayText(context)
    {
        RegisterObject(WagnisHUDinfo);

        this->wagnisgame = nullptr;
        this->bShow_ = false;
    }

    void WagnisHUDinfo::tick(float dt)
    {
        SUPER(WagnisHUDinfo, tick, dt);
        if(wagnisgame==nullptr){
            findWagnis();
        }
        switch(wagnisgame->active_player){
            case 1: setColour( colour({255,0,0}, 100.0f) );
                    break;
            case 2: setColour( colour({0,255,0}, 100.0f) );
                    break;
            case 3: setColour( colour({255,255,0}, 100.0f) );
                    break;
            case 4: setColour( colour({0,0,255}, 100.0f) );
                    break;
            case 5: setColour( colour({255,0,255}, 100.0f) );
                    break;
            case 6: setColour( colour({128,128,0}, 40.0f) );
                    break;
            case 7: setColour( colour({0,255,255}, 100.0f) );
                    break;
            case 8: setColour( colour({153,255,204}, 100.0f) );
                    break;
            case 9: setColour( colour({102,51,0}, 100.0f) );
                    break;
        }

        std::stringstream ss;
        switch(wagnisgame->gameStage){
            case CHOOSE_PROVINCE_STAGE: {
                ss<<"Player "<<wagnisgame->active_player<<" choose a province to occupy";
                setCaption( ss.str() );
                break;
            }
            case REINFORCEMENT_STAGE: {
                ss<<"Player "<<wagnisgame->active_player<<" place your reinforcements: "<<wagnisgame->players.at(wagnisgame->active_player-1)->reinforcements;
                setCaption( ss.str() );
                break;
            }
            case ATTACK_STAGE: {
                ss<<"Player "<<wagnisgame->active_player<<" you can attack now";
                setCaption( ss.str() );
                break;
            }
            case MOVE_STAGE: {
                ss<<"Player "<<wagnisgame->active_player<<" you can reorganize your troops now";
                setCaption( ss.str() );
                break;
            }
            case NOT_READY: {
                ss<<"";
                setCaption( ss.str() );
                break;
            }
            case WINNER_STAGE: {
                ss<<"PLAYER "<<wagnisgame->active_player<<" WINS!!!";
                setCaption( ss.str() );
                break;
            }
            default: {}
        }
    }
    void WagnisHUDinfo::findWagnis(){
    for (Wagnis* gb : ObjectList<Wagnis>()){
        this->wagnisgame = gb;
        orxout()<<"Wagnis pointer found and added"<<endl;
        return;
    }
}
}
