


#include "Wagnis.h"



namespace orxonox{

RegisterClass(Wagnis);

//Constructor
Wagnis::Wagnis(Context* context) : Deathmatch(context){
    RegisterObject(Wagnis);
    this->gameBoard = nullptr;
    this->gameStage = NOT_READY;
    this->active_player = 1;
    this->initial_reinforcements_left = 2; //changed here
    this->empty_provinces_left = 0;

    int n = 3;
    for(int i = 0;i < n;i++){
        WagnisPlayer* p = new WagnisPlayer(context);
        p->Player_ID = i+1;
        p->master = this;
        this->players.push_back(p);
    }
}
//Destructor
Wagnis::~Wagnis(){}


//Runs the game
void Wagnis::start(){
    Deathmatch::start();
    if(this->gameStage == NOT_READY){
        this->createGame();

        for(WagnisPlayer* ptr: this->players){
            ptr->gameBoard = this->gameBoard;
        }
    }

    this->gameStage = CHOOSE_PROVINCE_STAGE;
    this->empty_provinces_left = this->provinceCount();
    this->players.at(0)->gameStage = this->gameStage;
    this->players.at(0)->setActive(true);
    this->players.at(0)->reinforcements = 0;
    orxout()<<"Player "<<1<<"\'s turn. Please choose province."<<endl;
}

//Tick
void Wagnis::tick(float dt){
    SUPER(Wagnis,tick,dt);
}



/**
 * Callback function for Player classes. Needs to be called for the game to go on.
 * arg: player: pointer to the player which finished his stage.
 * (used to deactivate player after finishing)
 * enum GameStage { NOT_READY, CHOOSE_PROVINCE_STAGE, REINFORCEMENT_STAGE, ATTACK_STAGE, MOVE_STAGE };
 **/
void Wagnis::playerFinishedStageCallback(WagnisPlayer* player){

    player->resetProvinceSelection();

    if(this->active_player != player->Player_ID){
        orxout()<<"shit happend. This player should not be activ. Wagnis::playerFinishedStage was called from wrong player"<<endl;
    }
    switch(this->gameStage){
        case CHOOSE_PROVINCE_STAGE:{
            player->setActive(false);
            this->empty_provinces_left -= 1;
            if(this->empty_provinces_left > 0){
                //Still empty provinces left
                orxout()<<"DEBUG: Empty provs: "<<this->empty_provinces_left<<endl;

                if(this->active_player < this->players.size()){
                    this->active_player++;
                }else{
                    this->active_player = 1;
                }

                WagnisPlayer* next = this->players[this->active_player - 1];
                next->gameStage = CHOOSE_PROVINCE_STAGE;
                next->setActive(true);
                next->reinforcements = 0;
                orxout()<<"Player "<<next->Player_ID<<"\'s turn. Please choose province."<<endl;
            }else{
                //no empty provinces left
                orxout()<<"DEBUG: Empty provs: "<<this->empty_provinces_left<<endl;
                this->active_player = 1;
                WagnisPlayer* next = this->players[this->active_player - 1];
                next->gameStage = REINFORCEMENT_STAGE;
                this->gameStage = REINFORCEMENT_STAGE;
                next->setActive(true);
                next->reinforcements = 1;
                orxout()<<"Player "<<next->Player_ID<<"\'s turn. Reinforcement."<<endl;
            }
            break;
        }
        case REINFORCEMENT_STAGE:{
            
            if(this->initial_reinforcements_left > 0){
                player->setActive(false);
                if(this->active_player == this->players.size()){
                    //Last player finished this round of initial troops.
                    this->initial_reinforcements_left -= 1;
                    WagnisPlayer* next = this->players.at(0);
                    this->active_player = 1;
                    next->setActive(true);
                    next->gameStage = REINFORCEMENT_STAGE;
                    if(this->initial_reinforcements_left > 0){
                        //Still more troops left to place and player 1 is next.
                        next->reinforcements = 1;
                    }else{
                        //No more troops left to place and player 1 is next.
                        next->reinforcements = provincesOfPlayerCounter(1);
                    }
                }else{
                    //Player who finished was not the last player
                    WagnisPlayer* next = this->players.at(this->active_player);
                    this->active_player += 1;
                    next->setActive(true);
                    next->gameStage = REINFORCEMENT_STAGE;
                    next->reinforcements = 1;
                }
                break;
            }
            //Standard Reinforcement

            player->gameStage = ATTACK_STAGE;
            this->gameStage = ATTACK_STAGE;
            orxout()<<"Player "<<player->Player_ID<<"\'s turn. Attack."<<endl;
            break;
        }
        case ATTACK_STAGE:{
            player->gameStage = MOVE_STAGE;
            this->gameStage = MOVE_STAGE;
            orxout()<<"Player "<<player->Player_ID<<"\'s turn. Move."<<endl;
            break;
        }
        case MOVE_STAGE:{
            player->setActive(false);
            int tc;
            do{
                if(this->active_player < this->players.size()){
                    this->active_player++;
                }else{
                    this->active_player = 1;
                }
                tc = provincesOfPlayerCounter(this->active_player);
            }while(tc == 0); //Skip players without provinces.

            if(player->Player_ID == this->active_player){
                //If all players except one got skipped, we got a winner
                this->gameStage = WINNER_STAGE;
                player->gameStage = WINNER_STAGE;
            }else{
                WagnisPlayer* next = this->players[this->active_player - 1];
                orxout()<<"Player "<<next->Player_ID<<"\'s turn. Reinforcement."<<endl;
                next->gameStage = REINFORCEMENT_STAGE;
                this->gameStage = REINFORCEMENT_STAGE;
                next->setActive(true);
                next->reinforcements = tc;
            }
            
            break;
        }
        default:{}
    }
}




//Creates and links all needed classes
void Wagnis::createGame(){
    orxout() << "Game creation started" << endl;

    if(!findGameBoard()){
        orxout() << "Error: GameBoard not found" << endl;
    }

    this->gameBoard->initializeNeighbors();
    
    orxout() << "Game creation finished" << endl;
}

//Finds the pointer to the gameBoard
bool Wagnis::findGameBoard(){
    for (WagnisGameboard* gb : ObjectList<WagnisGameboard>()){
        this->gameBoard = gb;
        orxout()<<"Gameboard pointer found and added"<<endl;
        return true;
    }
    return false;
}

//Counts legit provinces(not including buttons)
int Wagnis::provinceCount(){
    int n = 0;
    for(WagnisProvince* p: this->gameBoard->provs){
        if(p != nullptr){
            if(p->ID < 1000){
                n++;
            }
        }else{
            orxout()<<"Nullpointer found in provinces!!!"<<endl;
        }
    }
    return n;
}

int Wagnis::provincesOfPlayerCounter(int player){
    int n = 0;
    for(WagnisProvince* p:this->gameBoard->provs){
        if(p != nullptr){
            if(p->getOwner_ID() == player){
                n++;
            }
        }else{
            orxout()<<"Nullpointer found in provinces!!!"<<endl;
        }
    }
    return n;
}













}


        
    