/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *
 *   Co-authors:
 *      ...
 */

#include "TixyTaxyTorxyHUDController.h"

#include "core/CoreIncludes.h"
#include "core/XMLPort.h"
#include "util/Convert.h"
#include "TixyTaxyTorxy.h"

namespace orxonox
{
    RegisterClass(TixyTaxyTorxyHUDController);

    TixyTaxyTorxyHUDController::TixyTaxyTorxyHUDController(Context* context) : OverlayText(context)
    {
        RegisterObject(TixyTaxyTorxyHUDController);
        this->tixyTaxyTorxy = nullptr;
    }

    TixyTaxyTorxyHUDController::~TixyTaxyTorxyHUDController()
    {

    }

    void TixyTaxyTorxyHUDController::tick(float dt)
    {
        SUPER(TixyTaxyTorxyHUDController, tick, dt);

        const std::string& lifes = multi_cast<std::string>(this->tixyTaxyTorxy->getLifes());
        const std::string& credits = multi_cast<std::string>(this->tixyTaxyTorxy->getCredit());
        const std::string& wave = multi_cast<std::string>(this->tixyTaxyTorxy->getWaveNumber());

        if(showlives == true)
        {
            this->setCaption(multi_cast<std::string>(lifes));
        }          
        else if(showcredits == true)
        {
            this->setCaption(multi_cast<std::string>(credits));
        }          
        else if(showwaves == true)
        {
            this->setCaption(multi_cast<std::string>(wave));
        }          
    }

    void TixyTaxyTorxyHUDController::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(TixyTaxyTorxyHUDController, XMLPort, xmlelement, mode);

        XMLPortParam(TixyTaxyTorxyHUDController, "showlives", setShowlives, getShowlives, xmlelement, mode);
        XMLPortParam(TixyTaxyTorxyHUDController, "showcredits", setShowcredits, getShowcredits, xmlelement, mode);
        XMLPortParam(TixyTaxyTorxyHUDController, "showwaves", setShowwaves, getShowwaves, xmlelement, mode);

    }

    void TixyTaxyTorxyHUDController::changedOwner()
        {
            SUPER(TixyTaxyTorxyHUDController, changedOwner);

            if (this->getOwner() && this->getOwner()->getGametype())
                    {
                        this->tixyTaxyTorxy = orxonox_cast<TixyTaxyTorxy*>(this->getOwner()->getGametype());
                    }
                    else
                    {
                        this->tixyTaxyTorxy = nullptr;
                    }
                }
        }

