/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      ...
 *   Co-authors:
 *      ...
 *
 */



#ifndef _TixyTaxyTorxyField_H__
#define _TixyTaxyTorxyField_H__

#include "TixyTaxyTorxy/TixyTaxyTorxyPrereqs.h"
#include "TixyTaxyTorxyTower.h"
#include "TixyTaxyTorxyCenterpoint.h"
#include <string>
#include "graphics/Model.h"
#include "worldentities/MovableEntity.h"

namespace orxonox
{
    enum class TixyTaxyTorxyFieldType
    { 
        FREE,
        STREET, 
        START, 
        END,
        OBSTACLE,
        TOWER1,
        TOWER2,
        TOWER
    };

    /**
    @brief
    See TixyTaxyTorxy
TixyTaxyTorxyReadme.txt for Information.
    @ingroup TixyTaxyTorxy
TixyTaxyTorxy
    */
    class _TixyTaxyTorxyExport TixyTaxyTorxyField : public MovableEntity
    {
        public:
            TixyTaxyTorxyField(Context* context);
            virtual ~TixyTaxyTorxyField() {}
            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode) override;
            const bool isFree() const
                { return type_==TixyTaxyTorxyFieldType::FREE; }
            const bool isTower1() const
                { return type_==TixyTaxyTorxyFieldType::TOWER1; }    
            const bool isTower2() const
                { return type_==TixyTaxyTorxyFieldType::TOWER2; }
            virtual void create(char object, char param);
            virtual void setCenterpoint(TixyTaxyTorxyCenterpoint* center);
            // virtual void upgrade();
             // virtual int getUpgrade();
            // virtual TixyTaxyTorxyFieldType getType();
            virtual void setUpgrade(int upgrade);
            // virtual bool canUpgrade();
            virtual void createFree(int orientation);
            virtual void createStart(int orientation);
            virtual void createEnd(int orientation);
            virtual void createStraight(int orientation);
            virtual void createLCurve(int orientation);
            virtual void createRCurve(int orientation);
            virtual void createObstacle(int orientation);
            virtual void createTower(int upgrade);
            virtual int getAngle();          
        private:

            virtual void setAngle(int newAngle);            
            virtual void destroyTower();
            int angle_;
            TixyTaxyTorxyFieldType type_;
            Model* modelGround_;
            Model* modelObject_;
            TixyTaxyTorxyTower* tower_;
            TixyTaxyTorxyCenterpoint* center_;
            int upgrade_;

    };    
}

#endif /* _TixyTaxyTorxy
TixyTaxyTorxyField_H__ */
