/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      ...
 *   Co-authors:
 *      ...
 *
 */

/**
    @file TixyTaxyTorxy
TixyTaxyTorxyField.cc
    @brief Implementation of the TixyTaxyTorxy
TixyTaxyTorxyField class.
*/

#include "TixyTaxyTorxyField.h"
#include "core/CoreIncludes.h"
#include "core/XMLPort.h"
#include "TixyTaxyTorxy.h"
#include <iostream>

using namespace std;

namespace orxonox
{
    RegisterClass(TixyTaxyTorxyField);
    int counter=0;
    /**
    @brief
        Constructor. Registers and initializes the object and checks whether the gametype is actually TixyTaxyTorxy
TixyTaxyTorxy.
    */
TixyTaxyTorxyField::TixyTaxyTorxyField(Context* context) : MovableEntity(context)
    {
        RegisterObject(TixyTaxyTorxyField);

        tower_ = nullptr;
        type_ = TixyTaxyTorxyFieldType::FREE;
        center_ = nullptr;
        upgrade_ = 0;
        setPosition(0,0,0);                            
        modelGround_ = new Model(getContext());
        modelGround_->setScale(25);
        modelGround_->pitch(Degree(90));
        attach(modelGround_);
        modelObject_ = new Model(getContext());
        modelObject_->setScale(25);
        modelObject_->pitch(Degree(90));
        attach(modelObject_);
        setAngle(0);
    }

    /**
    @brief
        Method to create a TixyTaxyTorxy
TixyTaxyTorxyField through XML.
    */
    void TixyTaxyTorxyField::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(TixyTaxyTorxyField, XMLPort, xmlelement, mode);

        //XMLPortParam(TixyTaxyTorxyField, "width", setWidth, getWidth, xmlelement, mode);

    }

    void TixyTaxyTorxyField::setCenterpoint(TixyTaxyTorxyCenterpoint* center)
    {
        center_ = center;
    }
    // void TixyTaxyTorxyField::upgrade()
    // {
    //     if (canUpgrade() == true)
    //     {
    //         destroyTower();
    //         createTower(getUpgrade() + 1);
    //     }
    // }

    // int TixyTaxyTorxyField::getUpgrade()
    // {
    //     return upgrade_;
    // }

    // TixyTaxyTorxyFieldType TixyTaxyTorxyField::getType()
    // {
    //     return type_;
    // }

    void TixyTaxyTorxyField::setUpgrade(int upgrade)
    {
       //  upgrade_= counter%2;
       // if (upgrade < 0)
       //  {
       //      upgrade_ = 0;
       //  }   
       //  else if (upgrade > 5)
       //  {
       //      upgrade = 5;
       //  }
       //  else
       //  {
       //      upgrade_ = upgrade;
        }

                                  
    // }

    // bool TixyTaxyTorxyField::canUpgrade()
    // {
    //     if (tower_ != nullptr && upgrade_ < 5)
    //     {
    //         return true;
    //     }

    //     return false;
    // }

    void TixyTaxyTorxyField::setAngle(int newAngle)
    {
        if (modelGround_ != nullptr)
        {
            switch (newAngle)
            {
            case 0:
                modelGround_->yaw(Degree(0));
                angle_ = 0;
                break;
            case 1:
                modelGround_->yaw(Degree(90));
                angle_ = 1;
                break;    
            case 2:
                modelGround_->yaw(Degree(180));
                angle_ = 2;
                break;   
            case 3:
                modelGround_->yaw(Degree(270));
                angle_ = 3;
                break;                                           
            }
        }

        if (modelObject_ != nullptr)
        {
            switch (newAngle)
            {
            case 0:
                modelObject_->yaw(Degree(0));
                angle_ = 0;
                break;
            case 1:
                modelObject_->yaw(Degree(90));
                angle_ = 1;
                break;    
            case 2:
                modelObject_->yaw(Degree(180));
                angle_ = 2;
                break;   
            case 3:
                modelObject_->yaw(Degree(270));
                angle_ = 3;
                break;                                           
            }
        }
        
    }


    int TixyTaxyTorxyField::getAngle()
    {
        return angle_;
    }

    void TixyTaxyTorxyField::createFree(int orientation)
    {            
        modelGround_->setMeshSource("TD_F1.mesh");
        tower_ = nullptr;
        type_ = TixyTaxyTorxyFieldType::FREE;
        setUpgrade(0);
        setAngle(orientation);
    }

    void TixyTaxyTorxyField::createStart(int orientation)
    {      
        modelGround_->setMeshSource("TD_S5.mesh");
        tower_ = nullptr;
        type_ = TixyTaxyTorxyFieldType::START;
        setUpgrade(0);
        setAngle(orientation);    
    }


    void TixyTaxyTorxyField::createEnd(int orientation)
    {     
        modelGround_->setMeshSource("TD_S4.mesh");
        tower_ = nullptr;
        type_ = TixyTaxyTorxyFieldType::END;
        setUpgrade(0);
        setAngle(orientation);
    }   

    void TixyTaxyTorxyField::createStraight(int orientation)
    {      
        modelGround_->setMeshSource("TD_S1.mesh");
        tower_ = nullptr;
        type_ = TixyTaxyTorxyFieldType::STREET;
        setUpgrade(0);
        setAngle(orientation);
    }  

    void TixyTaxyTorxyField::createRCurve(int orientation)
    {     
        modelGround_->setMeshSource("TD_S2.mesh");
        tower_ = nullptr;
        type_ = TixyTaxyTorxyFieldType::STREET;
        setUpgrade(0);
        setAngle(orientation);
    }  

    void TixyTaxyTorxyField::createLCurve(int orientation)
    {    
        modelGround_->setMeshSource("TD_S3.mesh");
        tower_ = nullptr;
        type_ = TixyTaxyTorxyFieldType::STREET;
        setUpgrade(0);
        setAngle(orientation);
    } 

    void TixyTaxyTorxyField::createObstacle(int orientation)
    {    
        modelGround_->setMeshSource("TD_F1.mesh");
        modelObject_->setMeshSource("TD_O1.mesh");
        tower_ = nullptr;
        type_ = TixyTaxyTorxyFieldType::OBSTACLE;
        setUpgrade(0);
        setAngle(orientation);
    }

    void TixyTaxyTorxyField::createTower(int upgrade)
    {        
        
        if (tower_ == nullptr)
        {
            counter++;
            if(counter%2==0){
            modelGround_->setMeshSource("TD_T1.mesh");
            tower_ = new TixyTaxyTorxyTower(center_->getContext());
            attach(tower_);
            type_ = TixyTaxyTorxyFieldType::TOWER1;

            }else{
            modelGround_->setMeshSource("TD_T2.mesh");
            tower_ = new TixyTaxyTorxyTower(center_->getContext());
            attach(tower_);
            type_ = TixyTaxyTorxyFieldType::TOWER2;  
        }

        }                           
    }

    void TixyTaxyTorxyField::destroyTower()
    {
        if (tower_ != nullptr)
        {
            tower_->destroy();
            tower_ = nullptr;
        }
    }

    void TixyTaxyTorxyField::create(char object, char param)
    {
        int paramInt = atoi(&param);
        switch (object)
        {
            case 'F':
                createFree(paramInt);
                break;
            case 'I':                
                createStraight(paramInt);
                break;
            case 'R':                
                createRCurve(paramInt);
                break;  
            case 'L':               
                createLCurve(paramInt);
                break;
            case 'X':               
                createStart(paramInt);
                break;     
            case 'O':               
                createEnd(paramInt);
                break;
            case 'Y':               
                createObstacle(paramInt);
                break;                 
            case 'T':                               
                createTower(paramInt);               
                break;                                                                                                         
        }
    }
}
